/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cli;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.jetlinks.simulator.cli.JLineInteractiveCommands;
import org.jetlinks.simulator.cli.TerminalAppender;
import org.jline.builtins.Completers;
import org.jline.console.SystemRegistry;
import org.jline.console.impl.Builtins;
import org.jline.console.impl.SystemRegistryImpl;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.MaskingCallback;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliCommands;
import picocli.shell.jline3.PicocliJLineCompleter;

public class InteractiveCLI {
    private final LineReader console;
    private final CommandLine commandLine;
    private final SystemRegistry systemRegistry;

    public InteractiveCLI(JLineInteractiveCommands commands) throws Exception {
        Terminal terminal = TerminalBuilder.builder().build();
        PicocliCommands.PicocliCommandsFactory factory = new PicocliCommands.PicocliCommandsFactory();
        factory.setTerminal(terminal);
        DefaultParser parser = new DefaultParser();
        Supplier<Path> workDir = () -> Paths.get("./", new String[0]);
        this.commandLine = new CommandLine(commands, factory);
        PicocliCommands picocliCommands = new PicocliCommands(this.commandLine){

            @Override
            public String name() {
                return "JetLinks Simulator";
            }
        };
        Builtins builtins = new Builtins(workDir, null, null);
        builtins.rename(Builtins.Command.TTOP, "top");
        this.systemRegistry = new SystemRegistryImpl(parser, terminal, workDir, null);
        this.systemRegistry.setCommandRegistries(builtins, picocliCommands);
        this.systemRegistry.register("help", picocliCommands);
        this.console = LineReaderBuilder.builder().terminal(terminal).completer(new AggregateCompleter(this.systemRegistry.completer(), new PicocliJLineCompleter(this.commandLine.getCommandSpec()), new Completers.FileNameCompleter())).parser(parser).variable("history-file", "history/simulator-cli-history").variable("history-ignore", "help|cls|clear|exit").variable("list-max", 50).build();
        commands.setConsole(this.console);
        commands.setCommandLine(this.commandLine);
        commands.setTerminal(terminal);
        Appender<ILoggingEvent> appender = ((Logger)LoggerFactory.getLogger("ROOT")).getAppender("TERMINAL");
        if (appender instanceof TerminalAppender) {
            ((TerminalAppender)appender).setConsole(this.console);
        }
    }

    public void showHelp() {
        this.systemRegistry.cleanUp();
        this.systemRegistry.execute("help");
    }

    /*
     * Unable to fully structure code
     */
    public void start() throws IOException {
        while (true) lbl-1000:
        // 3 sources

        {
            try {
                while (true) {
                    this.systemRegistry.cleanUp();
                    line = this.console.readLine(">", null, (MaskingCallback)null, null);
                    this.systemRegistry.execute(line);
                }
            }
            catch (UserInterruptException var2_4) {
            }
            catch (InterruptedException | EndOfFileException e) {
                return;
            }
            catch (Exception e) {
                this.systemRegistry.trace(e);
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
    }
}

