/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.message.HeaderKey;

public class ConverterUtils {
    public static <T> T convert(Object value, HeaderKey<T> key) {
        return ConverterUtils.convert(value, key.getValueType());
    }

    public static <T> T convert(Object value, Type type) {
        ParameterizedType parameterizedType;
        Type rawType;
        if (value == null || type == Object.class || type instanceof Class && ((Class)type).isInstance(value)) {
            return (T)value;
        }
        if (type instanceof Class) {
            return FastBeanCopier.DEFAULT_CONVERT.convert(value, (Class)type, FastBeanCopier.EMPTY_CLASS_ARRAY);
        }
        if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
            Type[] args = parameterizedType.getActualTypeArguments();
            Class[] arg = new Class[args.length];
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (!(args[i2] instanceof Class)) continue;
                arg[i2] = (Class)args[i2];
            }
            return FastBeanCopier.DEFAULT_CONVERT.convert(value, (Class)rawType, arg);
        }
        return TypeUtils.cast(value, type, ParserConfig.getGlobalInstance());
    }
}

