/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Optional;
import java.util.function.BiFunction;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ResourceUtils;

public class ClassUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassUtils.class);

    public static <T, Loader extends ClassLoader> Optional<T> findImplClass(Class<T> superType, String location, Loader loader, BiFunction<Loader, String, Class<?>> loadFunction) {
        boolean isJar = false;
        if (loader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                isJar = ResourceUtils.isJarURL(url) || url.getFile().endsWith("jar") || url.getFile().endsWith("zip");
            }
        }
        return ClassUtils.findImplClass(superType, location, isJar, loader, loadFunction);
    }

    public static <T, Loader extends ClassLoader> Optional<T> findImplClass(Class<T> superType, String location, final boolean jar, Loader loader, BiFunction<Loader, String, Class<?>> loadFunction) {
        try {
            Resource[] classes;
            CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory();
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver(loader){

                @Override
                protected boolean isJarResource(@NonNull Resource resource) {
                    if (resource == null) {
                        throw new NullPointerException("resource");
                    }
                    return jar;
                }
            };
            for (Resource aClass : classes = resourcePatternResolver.getResources(location)) {
                MetadataReader reader = metadataReaderFactory.getMetadataReader(aClass);
                AnnotationMetadata annotationMetadata = reader.getAnnotationMetadata();
                if (annotationMetadata.hasAnnotation("java.lang.Deprecated")) continue;
                ClassMetadata classMetadata = reader.getClassMetadata();
                try {
                    Class<?> clazz = loadFunction.apply(loader, classMetadata.getClassName());
                    if (!superType.isAssignableFrom(clazz)) continue;
                    return Optional.of(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            metadataReaderFactory.clearCache();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        return Optional.empty();
    }
}

