/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import org.jetlinks.core.trace.TraceHolder;
import org.jetlinks.core.trace.TraceSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.util.context.ContextView;

public class TraceMono<T>
extends MonoOperator<T, T> {
    private static final Logger log = LoggerFactory.getLogger(TraceMono.class);
    private final String spanName;
    private final Tracer tracer;
    private final BiConsumer<Span, T> onNext;
    private final BiConsumer<Span, Long> onComplete;
    private final BiConsumer<ContextView, SpanBuilder> onSubscription;

    public static <T> TraceMono<T> trace(Mono<T> source) {
        return new TraceMono<T>(source, null, null, null, null, null);
    }

    TraceMono(Mono<? extends T> source, String name, Tracer tracer, BiConsumer<Span, T> onNext, BiConsumer<Span, Long> onComplete, BiConsumer<ContextView, SpanBuilder> builderConsumer) {
        super(source);
        this.spanName = name == null ? this.name() : name;
        this.tracer = tracer == null ? TraceHolder.telemetry().getTracer(TraceHolder.appName()) : tracer;
        this.onNext = onNext;
        this.onSubscription = builderConsumer;
        this.onComplete = onComplete;
    }

    public TraceMono<T> spanName(String spanName) {
        return new TraceMono<T>(this.source, spanName, this.tracer, this.onNext, this.onComplete, this.onSubscription);
    }

    public TraceMono<T> scopeName(String scopeName) {
        return new TraceMono<T>(this.source, this.spanName, TraceHolder.telemetry().getTracer(scopeName), this.onNext, this.onComplete, this.onSubscription);
    }

    public TraceMono<T> scopeName(String scopeName, String scopeVersion) {
        return new TraceMono<T>(this.source, this.spanName, TraceHolder.telemetry().getTracer(scopeName, scopeVersion), this.onNext, this.onComplete, this.onSubscription);
    }

    public TraceMono<T> onNext(BiConsumer<Span, T> onNext) {
        if (this.onNext != null) {
            onNext = this.onNext.andThen(onNext);
        }
        return new TraceMono<T>(this.source, this.spanName, this.tracer, onNext, this.onComplete, this.onSubscription);
    }

    public TraceMono<T> onComplete(BiConsumer<Span, Long> onComplete) {
        if (this.onComplete != null) {
            onComplete = this.onComplete.andThen(onComplete);
        }
        return new TraceMono<T>(this.source, this.spanName, this.tracer, this.onNext, onComplete, this.onSubscription);
    }

    public TraceMono<T> onSubscription(BiConsumer<ContextView, SpanBuilder> onSubscription) {
        if (this.onSubscription != null) {
            onSubscription = this.onSubscription.andThen(onSubscription);
        }
        return new TraceMono<T>(this.source, this.spanName, this.tracer, this.onNext, this.onComplete, onSubscription);
    }

    @Override
    public void subscribe(@Nonnull CoreSubscriber<? super T> actual) {
        try {
            SpanBuilder builder = this.tracer.spanBuilder(this.spanName);
            reactor.util.context.Context context = actual.currentContext();
            Context ctx = context.getOrEmpty(Context.class).orElseGet(Context::root);
            if (null != this.onSubscription) {
                this.onSubscription.accept(context, builder);
            }
            Span span = builder.setParent(ctx).startSpan();
            this.source.subscribe(new TraceSubscriber<T>(actual, span, this.onNext, this.onComplete, ctx));
        }
        catch (Throwable e) {
            actual.onError(e);
        }
    }
}

