/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections.MapUtils;
import org.jetlinks.core.topic.Topic;
import org.jetlinks.core.trace.MapTextMapGetter;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.function.Consumer3;
import reactor.util.context.ContextView;

public class TraceHolder {
    private static String GLOBAL_APP_NAME = System.getProperty("trace.app.name", "default");
    private static boolean traceEnabled = Boolean.parseBoolean(System.getProperty("trace.enabled", "true"));
    private static final Topic<String> disabledSpanName = Topic.createRoot();
    private static final Topic<String> enabledSpanName = Topic.createRoot();
    private static OpenTelemetry telemetry;

    public static void setup(OpenTelemetry telemetry) {
        TraceHolder.telemetry = telemetry;
    }

    public static void setupGlobalName(String name) {
        GLOBAL_APP_NAME = name;
    }

    public static String appName() {
        return GLOBAL_APP_NAME;
    }

    public static boolean isEnabled() {
        return traceEnabled;
    }

    public static boolean isDisabled() {
        return !TraceHolder.isEnabled();
    }

    public static boolean isEnabled(String name) {
        if (!traceEnabled) {
            return false;
        }
        AtomicReference enabled = new AtomicReference();
        enabledSpanName.findTopic(name, topic -> enabled.set(true), () -> {});
        if (enabled.get() == null) {
            disabledSpanName.findTopic(name, topic -> enabled.set(false), () -> {});
        }
        if (enabled.get() == null) {
            return true;
        }
        return (Boolean)enabled.get();
    }

    public static boolean isDisabled(String name) {
        return !TraceHolder.isEnabled(name);
    }

    public static void enable() {
        traceEnabled = true;
    }

    public static void disable() {
        traceEnabled = false;
    }

    public static Disposable enable(String spanName, String handler) {
        TraceHolder.removeDisabled(spanName, handler);
        Topic<String> subTable = enabledSpanName.append(spanName);
        subTable.subscribe((String[])new String[]{handler});
        return () -> subTable.unsubscribe(handler);
    }

    public static void removeEnabled(String spanName, String handler) {
        enabledSpanName.getTopic(spanName).ifPresent(topic -> topic.unsubscribe(handler));
    }

    public static void removeDisabled(String spanName, String handler) {
        disabledSpanName.getTopic(spanName).ifPresent(topic -> topic.unsubscribe(handler));
    }

    public static void disable(String spanName, String handler) {
        disabledSpanName.append(spanName).subscribe((String[])new String[]{handler});
        TraceHolder.removeEnabled(spanName, handler);
    }

    public static OpenTelemetry telemetry() {
        return telemetry == null ? OpenTelemetry.noop() : telemetry;
    }

    public static reactor.util.context.Context readToContext(ContextView parent, Map<String, ?> carrier) {
        if (TraceHolder.isDisabled() || MapUtils.isEmpty(carrier)) {
            return reactor.util.context.Context.of(parent);
        }
        return TraceHolder.readToContext(parent, carrier, MapTextMapGetter.instance());
    }

    public static <T> reactor.util.context.Context readToContext(ContextView parent, T source, TextMapGetter<T> getter) {
        ContextPropagators propagators = TraceHolder.telemetry().getPropagators();
        TextMapPropagator propagator = propagators.getTextMapPropagator();
        Context context = parent.getOrDefault(Context.class, Context.root());
        if (null != context) {
            context = propagator.extract(context, source, getter);
            return reactor.util.context.Context.of(Context.class, context);
        }
        return reactor.util.context.Context.of(parent);
    }

    public static <T> T writeContextTo(ContextView ctx, T carrier, Consumer3<T, String, String> setter) {
        if (TraceHolder.isDisabled()) {
            return carrier;
        }
        ContextPropagators propagators = TraceHolder.telemetry().getPropagators();
        TextMapPropagator propagator = propagators.getTextMapPropagator();
        Context context = ctx.getOrDefault(Context.class, Context.root());
        if (null != context) {
            propagator.inject(context, carrier, setter::accept);
        }
        return carrier;
    }

    public static <T> Mono<T> writeContextTo(T carrier, Consumer3<T, String, String> setter) {
        if (TraceHolder.isDisabled()) {
            return Mono.just(carrier);
        }
        return Mono.deferContextual(ctx -> Mono.just(TraceHolder.writeContextTo(ctx, carrier, setter)));
    }

    public static <D> D copyContext(Map<String, ?> source, D carrier, Consumer3<D, String, String> setter) {
        if (TraceHolder.isDisabled()) {
            return carrier;
        }
        return TraceHolder.writeContextTo(TraceHolder.readToContext(reactor.util.context.Context.empty(), source), carrier, setter);
    }
}

