/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.propagation.TextMapGetter;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.collections.MapUtils;
import org.jetlinks.core.trace.MapTextMapGetter;
import org.jetlinks.core.trace.MonoTracerBuilder;
import org.jetlinks.core.trace.ReactiveTracerBuilder;
import org.jetlinks.core.trace.TraceHolder;
import reactor.core.publisher.Mono;

public interface MonoTracer<T>
extends Function<Mono<T>, Mono<T>> {
    public static <T> MonoTracer<T> unsupported() {
        return source -> source;
    }

    public static <T> ReactiveTracerBuilder<MonoTracer<T>, T> builder() {
        return new MonoTracerBuilder();
    }

    public static <T> MonoTracer<T> create(String spanName) {
        return MonoTracer.create(TraceHolder.appName(), spanName);
    }

    public static <T> MonoTracer<T> create(String scopeName, String spanName) {
        return MonoTracer.create(scopeName, spanName, null, null);
    }

    public static <T> MonoTracer<T> create(String spanName, BiConsumer<Span, T> onNext) {
        return MonoTracer.create(TraceHolder.appName(), spanName, onNext, null);
    }

    public static <T> MonoTracer<T> create(String scopeName, String spanName, BiConsumer<Span, T> onNext) {
        return MonoTracer.create(scopeName, spanName, onNext, null);
    }

    public static <T> MonoTracer<T> create(String spanName, Consumer<SpanBuilder> builderConsumer) {
        return MonoTracer.create(TraceHolder.appName(), spanName, null, builderConsumer);
    }

    public static <T> MonoTracer<T> create(String scopeName, String spanName, Consumer<SpanBuilder> builderConsumer) {
        return MonoTracer.create(scopeName, spanName, null, builderConsumer);
    }

    public static <T> MonoTracer<T> create(String spanName, BiConsumer<Span, T> onNext, Consumer<SpanBuilder> builderConsumer) {
        return MonoTracer.create(TraceHolder.appName(), spanName, onNext, builderConsumer);
    }

    public static <T> MonoTracer<T> create(String spanName, BiConsumer<Span, T> onNext, BiConsumer<Span, Boolean> onComplete) {
        return MonoTracer.create(TraceHolder.appName(), spanName, onNext, onComplete, null);
    }

    public static <T> MonoTracer<T> create(String scopeName, String spanName, BiConsumer<Span, T> onNext, Consumer<SpanBuilder> builderConsumer) {
        return MonoTracer.create(scopeName, spanName, onNext, null, builderConsumer);
    }

    public static <T> MonoTracer<T> create(String scopeName, String spanName, BiConsumer<Span, T> onNext, BiConsumer<Span, Boolean> onComplete, Consumer<SpanBuilder> builderConsumer) {
        if (TraceHolder.isDisabled(spanName)) {
            return MonoTracer.unsupported();
        }
        return MonoTracer.builder().scopeName(scopeName).spanName(spanName).onNext(onNext).onComplete(onComplete != null ? (span, total) -> onComplete.accept((Span)span, total > 0L) : null).onSubscription(builderConsumer).build();
    }

    public static <R> MonoTracer<R> createWith(Map<String, ?> carrier) {
        if (TraceHolder.isDisabled() || MapUtils.isEmpty(carrier)) {
            return MonoTracer.unsupported();
        }
        return MonoTracer.createWith(carrier, MapTextMapGetter.instance());
    }

    public static <T, R> MonoTracer<R> createWith(T source, TextMapGetter<T> getter) {
        if (TraceHolder.isDisabled()) {
            return MonoTracer.unsupported();
        }
        return mono -> Mono.deferContextual(ctx -> mono.contextWrite(TraceHolder.readToContext(ctx, source, getter)));
    }
}

