/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.types;

import java.util.HashMap;
import java.util.Map;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.config.ConfigKeyValue;
import org.jetlinks.core.metadata.DataType;
import org.springframework.util.CollectionUtils;

public abstract class AbstractType<Self extends AbstractType<Self>>
implements DataType {
    private Map<String, Object> expands;
    private String description;

    public Self expands(Map<String, Object> expands) {
        if (CollectionUtils.isEmpty(expands)) {
            return this.castSelf();
        }
        if (this.expands == null) {
            this.expands = new HashMap<String, Object>();
        }
        this.expands.putAll(expands);
        return this.castSelf();
    }

    public Self expand(ConfigKeyValue<?> ... kvs) {
        for (ConfigKeyValue<?> kv : kvs) {
            this.expand(kv.getKey(), kv.getValue());
        }
        return this.castSelf();
    }

    public <V> Self expand(ConfigKey<V> configKey, V value) {
        return this.expand(configKey.getKey(), value);
    }

    public Self expand(String configKey, Object value) {
        if (value == null) {
            return this.castSelf();
        }
        if (this.expands == null) {
            this.expands = new HashMap<String, Object>();
        }
        this.expands.put(configKey, value);
        return this.castSelf();
    }

    public Self description(String description) {
        this.description = description;
        return this.castSelf();
    }

    protected Self castSelf() {
        return (Self)this;
    }

    @Override
    public Map<String, Object> getExpands() {
        return this.expands;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setExpands(Map<String, Object> expands) {
        this.expands = expands;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }
}

