/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.property;

import com.alibaba.fastjson.JSONObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetlinks.core.message.CommonDeviceMessageReply;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.property.WriteThingPropertyMessageReply;
import org.jetlinks.core.things.ThingProperty;

public class WritePropertyMessageReply
extends CommonDeviceMessageReply<WritePropertyMessageReply>
implements WriteThingPropertyMessageReply {
    private Map<String, Object> properties;
    private Map<String, Long> propertySourceTimes;
    private Map<String, String> propertyStates;

    @Override
    public WritePropertyMessageReply success(Map<String, Object> properties) {
        this.properties = properties;
        super.setSuccess(true);
        return this;
    }

    @Override
    public WritePropertyMessageReply success(List<ThingProperty> properties) {
        this.properties = new LinkedHashMap<String, Object>();
        this.propertySourceTimes = new LinkedHashMap<String, Long>();
        this.propertyStates = new LinkedHashMap<String, String>();
        for (ThingProperty property : properties) {
            this.properties.put(property.getProperty(), property.getValue());
            this.propertySourceTimes.put(property.getProperty(), property.getTimestamp());
            this.propertyStates.put(property.getProperty(), property.getState());
        }
        return this;
    }

    @Override
    public WritePropertyMessageReply propertySourceTimes(Map<String, Long> times) {
        this.propertySourceTimes = times;
        return this;
    }

    @Override
    public WritePropertyMessageReply propertyStates(Map<String, String> states) {
        this.propertyStates = states;
        return this;
    }

    @Override
    public WritePropertyMessageReply properties(Map<String, Object> properties) {
        return this.success((Map)properties);
    }

    public synchronized WritePropertyMessageReply addProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        }
        this.properties.put(key, value);
        return this;
    }

    public static WritePropertyMessageReply create() {
        WritePropertyMessageReply reply = new WritePropertyMessageReply();
        reply.setTimestamp(System.currentTimeMillis());
        return reply;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.properties = jsonObject.getJSONObject("properties");
        this.propertySourceTimes = jsonObject.getJSONObject("propertySourceTimes");
        this.propertyStates = jsonObject.getJSONObject("propertyStates");
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.WRITE_PROPERTY_REPLY;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public Map<String, Long> getPropertySourceTimes() {
        return this.propertySourceTimes;
    }

    @Override
    public Map<String, String> getPropertyStates() {
        return this.propertyStates;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setPropertySourceTimes(Map<String, Long> propertySourceTimes) {
        this.propertySourceTimes = propertySourceTimes;
    }

    public void setPropertyStates(Map<String, String> propertyStates) {
        this.propertyStates = propertyStates;
    }
}

