/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import javax.annotation.Nonnull;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.MessageDecodeContext;
import org.jetlinks.core.server.session.DeviceSession;
import reactor.core.publisher.Mono;

public interface FromDeviceMessageContext
extends MessageDecodeContext {
    public DeviceSession getSession();

    @Override
    default public DeviceOperator getDevice() {
        return this.getSession().getOperator();
    }

    public static FromDeviceMessageContext of(final DeviceSession session, final EncodedMessage message) {
        return new FromDeviceMessageContext(){

            @Override
            public DeviceSession getSession() {
                return session;
            }

            @Override
            @Nonnull
            public EncodedMessage getMessage() {
                return message;
            }
        };
    }

    public static FromDeviceMessageContext of(final DeviceSession session, final EncodedMessage message, final DeviceRegistry registry) {
        return new FromDeviceMessageContext(){

            @Override
            public DeviceSession getSession() {
                return session;
            }

            @Override
            @Nonnull
            public EncodedMessage getMessage() {
                return message;
            }

            @Override
            public Mono<DeviceOperator> getDevice(String deviceId) {
                return registry.getDevice(deviceId);
            }
        };
    }
}

