/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetlinks.core.message.HeaderKey;
import org.jetlinks.core.message.Headers;
import org.jetlinks.core.message.property.ReadPropertyMessage;
import org.jetlinks.core.message.property.ReadPropertyMessageReply;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReadPropertyMessageSender {
    public ReadPropertyMessageSender custom(Consumer<ReadPropertyMessage> var1);

    public ReadPropertyMessageSender header(String var1, Object var2);

    public ReadPropertyMessageSender messageId(String var1);

    public Flux<ReadPropertyMessageReply> send();

    default public Mono<Void> sendAndForget() {
        return this.header(Headers.sendAndForget, true).send().then();
    }

    public ReadPropertyMessageSender read(Collection<String> var1);

    default public ReadPropertyMessageSender read(String ... property) {
        return this.read(Arrays.asList(property));
    }

    default public ReadPropertyMessageSender accept(Consumer<ReadPropertyMessageSender> consumer) {
        consumer.accept(this);
        return this;
    }

    default public ReadPropertyMessageSender timeout(Duration timeout) {
        return this.header(Headers.timeout, timeout.toMillis());
    }

    default public ReadPropertyMessageSender async() {
        return this.async(true);
    }

    default public ReadPropertyMessageSender async(Boolean async) {
        return this.header(Headers.async, async);
    }

    default public <T> ReadPropertyMessageSender header(HeaderKey<T> header, T value) {
        return this.header(header.getKey(), value);
    }

    default public ReadPropertyMessageSender headers(Map<String, Object> headers2) {
        Objects.requireNonNull(headers2).forEach(this::header);
        return this;
    }
}

