/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.exception;

import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.core.enums.ErrorCode;

public class DeviceOperationException
extends RuntimeException {
    private final ErrorCode code;
    private final String message;

    public DeviceOperationException(ErrorCode errorCode) {
        this(errorCode, errorCode.getText());
    }

    public DeviceOperationException(ErrorCode errorCode, Throwable cause) {
        super(cause);
        this.code = errorCode;
        this.message = cause.getMessage();
    }

    public DeviceOperationException(ErrorCode code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public String getMessage() {
        return this.message == null ? this.code.getText() : this.message;
    }

    @Override
    public String getLocalizedMessage() {
        return LocaleUtils.resolveMessage(this.getMessage(), new Object[0]);
    }

    public ErrorCode getCode() {
        return this.code;
    }
}

