/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.device;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.config.ConfigKeyValue;
import org.springframework.util.StringUtils;

public class ProductInfo
implements Serializable {
    private static final long serialVersionUID = -6849794470754667710L;
    private String id;
    private String protocol;
    private String metadata;
    private Map<String, Object> configuration = new HashMap<String, Object>();
    private String version;

    public ProductInfo(String id, String protocol, String metadata) {
        this.id = id;
        this.protocol = protocol;
        this.metadata = metadata;
    }

    public ProductInfo addConfig(String key, Object value) {
        if (StringUtils.isEmpty(value)) {
            return this;
        }
        if (this.configuration == null) {
            this.configuration = new HashMap<String, Object>();
        }
        this.configuration.put(key, value);
        return this;
    }

    public ProductInfo addConfigs(Map<String, ?> configs) {
        if (configs == null) {
            return this;
        }
        configs.forEach(this::addConfig);
        return this;
    }

    public <T> ProductInfo addConfig(ConfigKey<T> key, T value) {
        this.addConfig(key.getKey(), value);
        return this;
    }

    public <T> ProductInfo addConfig(ConfigKeyValue<T> keyValue) {
        this.addConfig(keyValue.getKey(), keyValue.getValue());
        return this;
    }

    public static ProductInfoBuilder builder() {
        return new ProductInfoBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public String getVersion() {
        return this.version;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ProductInfo() {
    }

    public ProductInfo(String id, String protocol, String metadata, Map<String, Object> configuration, String version) {
        this.id = id;
        this.protocol = protocol;
        this.metadata = metadata;
        this.configuration = configuration;
        this.version = version;
    }

    public static class ProductInfoBuilder {
        private String id;
        private String protocol;
        private String metadata;
        private Map<String, Object> configuration;
        private String version;

        ProductInfoBuilder() {
        }

        public ProductInfoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ProductInfoBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public ProductInfoBuilder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public ProductInfoBuilder configuration(Map<String, Object> configuration) {
            this.configuration = configuration;
            return this;
        }

        public ProductInfoBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ProductInfo build() {
            return new ProductInfo(this.id, this.protocol, this.metadata, this.configuration, this.version);
        }

        public String toString() {
            return "ProductInfo.ProductInfoBuilder(id=" + this.id + ", protocol=" + this.protocol + ", metadata=" + this.metadata + ", configuration=" + this.configuration + ", version=" + this.version + ")";
        }
    }
}

