/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.codec.defaults;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Codec;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.MessageType;

public class MessageCodec
implements Codec<Message> {
    public static MessageCodec INSTANCE = new MessageCodec();

    @Override
    public Class<Message> forType() {
        return Message.class;
    }

    @Override
    @Nullable
    public Message decode(@Nonnull Payload payload) {
        JSONObject json = JSON.parseObject(payload.bodyToString(false));
        return (Message)MessageType.convertMessage(json).orElseThrow(() -> new UnsupportedOperationException("unsupported message : " + json));
    }

    @Override
    public Payload encode(Message body2) {
        return Payload.of(JSON.toJSONBytes((Object)body2.toJson(), new SerializerFeature[0]));
    }

    private MessageCodec() {
    }
}

