/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core;

import java.lang.reflect.Type;
import java.util.Date;
import org.jetlinks.core.SimpleValue;
import org.jetlinks.core.utils.ConverterUtils;

public interface Value {
    default public String asString() {
        return String.valueOf(this.get());
    }

    default public int asInt() {
        return this.as(Integer.class);
    }

    default public long asLong() {
        return this.as(Long.class);
    }

    default public boolean asBoolean() {
        return Boolean.TRUE.equals(this.get()) || "true".equals(this.get());
    }

    default public Number asNumber() {
        return this.as(Number.class);
    }

    default public Date asDate() {
        return this.as(Date.class);
    }

    public Object get();

    default public <T> T as(Class<T> type) {
        return ConverterUtils.convert(this.get(), type);
    }

    default public <T> T as(Type type) {
        return ConverterUtils.convert(this.get(), type);
    }

    public static Value simple(Object value) {
        return SimpleValue.of(value);
    }
}

