/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtilsBean2;
import org.hswebframework.expands.script.engine.DynamicScriptEngine;
import org.hswebframework.expands.script.engine.DynamicScriptEngineFactory;
import org.hswebframework.web.utils.DigestUtils;
import org.hswebframework.web.utils.TemplateParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ExpressionUtils {
    private static final Logger log = LoggerFactory.getLogger(ExpressionUtils.class);
    private static final Pattern PATTERN = Pattern.compile("(?<=\\$\\{)(.+?)(?=})");

    public static Map<String, Object> getDefaultVar() {
        return new HashMap<String, Object>();
    }

    public static Map<String, Object> getDefaultVar(Map<String, Object> var) {
        Map<String, Object> vars = ExpressionUtils.getDefaultVar();
        vars.putAll(var);
        return vars;
    }

    public static String analytical(String expression, String language) throws Exception {
        return ExpressionUtils.analytical(expression, new HashMap<String, Object>(), language);
    }

    public static String analytical(String expression, Map<String, Object> vars, String language) {
        if (!expression.contains("${")) {
            return expression;
        }
        DynamicScriptEngine engine = DynamicScriptEngineFactory.getEngine(language);
        if (engine == null) {
            return expression;
        }
        return TemplateParser.parse(expression, var -> {
            if (StringUtils.isEmpty(var)) {
                return "";
            }
            Object val = vars.get(var);
            if (val != null) {
                return String.valueOf(val);
            }
            if ("spel".equalsIgnoreCase(language) && !var.contains("#")) {
                try {
                    Object fast = BeanUtilsBean2.getInstance().getPropertyUtils().getProperty(vars, (String)var);
                    if (fast != null) {
                        return fast.toString();
                    }
                }
                catch (Exception ignore) {
                    return "";
                }
            }
            String id = DigestUtils.md5Hex(var);
            try {
                if (!engine.compiled(id)) {
                    engine.compile(id, (String)var);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                return String.valueOf(engine.execute(id, vars).getIfSuccess());
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
                return "";
            }
        });
    }
}

