/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static <T extends Annotation> T findMethodAnnotation(Class targetClass, Method method2, Class<T> annClass) {
        Method m3 = method2;
        T a = org.springframework.core.annotation.AnnotationUtils.findAnnotation(m3, annClass);
        if (a != null) {
            return a;
        }
        a = org.springframework.core.annotation.AnnotationUtils.findAnnotation(m3 = ClassUtils.getMostSpecificMethod(m3, targetClass), annClass);
        if (a == null) {
            ArrayList supers = new ArrayList(Arrays.asList(targetClass.getInterfaces()));
            if (targetClass.getSuperclass() != Object.class) {
                supers.add(targetClass.getSuperclass());
            }
            for (Class clazz : supers) {
                if (clazz == null) continue;
                AtomicReference methodRef = new AtomicReference();
                ReflectionUtils.doWithMethods(clazz, im -> {
                    if (im.getName().equals(method2.getName()) && im.getParameterCount() == method2.getParameterCount()) {
                        methodRef.set(im);
                    }
                });
                if (methodRef.get() == null || (a = AnnotationUtils.findMethodAnnotation(clazz, (Method)methodRef.get(), annClass)) == null) continue;
                return a;
            }
        }
        return a;
    }

    public static <T extends Annotation> T findAnnotation(Class targetClass, Class<T> annClass) {
        return org.springframework.core.annotation.AnnotationUtils.findAnnotation(targetClass, annClass);
    }

    public static <T extends Annotation> T findAnnotation(Class targetClass, Method method2, Class<T> annClass) {
        T a = AnnotationUtils.findMethodAnnotation(targetClass, method2, annClass);
        if (a != null) {
            return a;
        }
        return AnnotationUtils.findAnnotation(targetClass, annClass);
    }

    public static <T extends Annotation> T findAnnotation(JoinPoint pjp, Class<T> annClass) {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method m3 = signature.getMethod();
        Class<?> targetClass = pjp.getTarget().getClass();
        return AnnotationUtils.findAnnotation(targetClass, m3, annClass);
    }

    public static String getMethodBody(JoinPoint pjp) {
        StringBuilder methodName = new StringBuilder(pjp.getSignature().getName()).append("(");
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        String[] names = signature.getParameterNames();
        Class[] args = signature.getParameterTypes();
        int len = args.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 != 0) {
                methodName.append(",");
            }
            methodName.append(args[i2].getSimpleName()).append(" ").append(names[i2]);
        }
        return methodName.append(")").toString();
    }

    public static Map<String, Object> getArgsMap(JoinPoint pjp) {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        String[] names = signature.getParameterNames();
        int len = names.length;
        for (int i2 = 0; i2 < len; ++i2) {
            args.put(names[i2], pjp.getArgs()[i2]);
        }
        return args;
    }
}

