/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.hswebframework.web.context.Context;
import org.hswebframework.web.context.ContextKey;

class MapContext
implements Context {
    private Map<String, Object> map = new ConcurrentHashMap<String, Object>();

    MapContext() {
    }

    @Override
    public <T> Optional<T> get(ContextKey<T> key) {
        return Optional.ofNullable(this.map.get(key.getKey())).map(v -> v);
    }

    @Override
    public <T> T getOrDefault(ContextKey<T> key, Supplier<? extends T> defaultValue) {
        return (T)this.map.computeIfAbsent(key.getKey(), __ -> defaultValue.get());
    }

    @Override
    public <T> void put(ContextKey<T> key, T value) {
        this.map.put(key.getKey(), value);
    }

    @Override
    public <T> T remove(ContextKey<T> key) {
        return (T)this.map.remove(key);
    }

    @Override
    public Map<String, Object> getAll() {
        return new HashMap<String, Object>(this.map);
    }

    @Override
    public void clean() {
        this.map.clear();
    }
}

