/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocket07FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker00;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker07;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker08;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker13;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateClientExtensionHandshaker;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.http.impl.AssembledFullHttpRequest;
import io.vertx.core.http.impl.AssembledHttpRequest;
import io.vertx.core.http.impl.Http1xConnectionBase;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientPush;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.http.impl.HttpResponseHead;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.WebSocketHandshakeInboundHandler;
import io.vertx.core.http.impl.WebSocketImpl;
import io.vertx.core.http.impl.headers.HeadersAdaptor;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.streams.WriteStream;
import io.vertx.core.streams.impl.InboundBuffer;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class Http1xClientConnection
extends Http1xConnectionBase<WebSocketImpl>
implements HttpClientConnection {
    private static final Logger log = LoggerFactory.getLogger(Http1xClientConnection.class);
    private static final Handler<Object> INVALID_MSG_HANDLER = msg -> {
        ReferenceCountUtil.release(msg);
        throw new IllegalStateException("Invalid object " + msg);
    };
    private final HttpClientImpl client;
    private final HttpClientOptions options;
    private final boolean ssl;
    private final SocketAddress server;
    public final ClientMetrics metrics;
    private final HttpVersion version;
    private final long lowWaterMark;
    private final long highWaterMark;
    private Deque<Stream> requests = new ArrayDeque<Stream>();
    private Deque<Stream> responses = new ArrayDeque<Stream>();
    private boolean closed;
    private boolean evicted;
    private Handler<Void> evictionHandler = DEFAULT_EVICTION_HANDLER;
    private Handler<Object> invalidMessageHandler = INVALID_MSG_HANDLER;
    private boolean close;
    private boolean shutdown;
    private long shutdownTimerID = -1L;
    private boolean isConnect;
    private int keepAliveTimeout;
    private long expirationTimestamp;
    private int seq = 1;
    private long readWindow;
    private long writeWindow;
    private boolean writeOverflow;
    private long lastResponseReceivedTimestamp;

    Http1xClientConnection(HttpVersion version, HttpClientImpl client, ChannelHandlerContext channel, boolean ssl, SocketAddress server, ContextInternal context, ClientMetrics metrics) {
        super(context, channel);
        this.client = client;
        this.options = client.options();
        this.ssl = ssl;
        this.server = server;
        this.metrics = metrics;
        this.version = version;
        this.readWindow = 0L;
        this.writeWindow = 0L;
        this.highWaterMark = channel.channel().config().getWriteBufferHighWaterMark();
        this.lowWaterMark = channel.channel().config().getWriteBufferLowWaterMark();
        this.keepAliveTimeout = this.options.getKeepAliveTimeout();
        this.expirationTimestamp = Http1xClientConnection.expirationTimestampOf(this.keepAliveTimeout);
    }

    @Override
    public HttpClientConnection evictionHandler(Handler<Void> handler) {
        this.evictionHandler = handler;
        return this;
    }

    @Override
    public HttpClientConnection concurrencyChangeHandler(Handler<Long> handler) {
        return this;
    }

    @Override
    public long concurrency() {
        return this.options.isPipelining() ? (long)this.options.getPipeliningLimit() : 1L;
    }

    public NetSocketInternal toNetSocket() {
        this.removeChannelHandlers();
        NetSocketImpl socket = new NetSocketImpl(this.context, this.chctx, null, this.metrics());
        socket.metric(this.metric());
        this.evictionHandler.handle(null);
        this.chctx.pipeline().replace("handler", "handler", VertxHandler.create(ctx -> socket));
        return socket;
    }

    private HttpRequest createRequest(HttpMethod method2, String uri, MultiMap headerMap, String authority, boolean chunked, ByteBuf buf, boolean end) {
        HttpRequest request = new DefaultHttpRequest(HttpUtils.toNettyHttpVersion(this.version), method2.toNetty(), uri, false);
        io.netty.handler.codec.http.HttpHeaders headers2 = request.headers();
        if (headerMap != null) {
            for (Map.Entry header : headerMap) {
                headers2.add((String)header.getKey(), header.getValue());
            }
        }
        if (!headers2.contains(HttpHeaders.HOST)) {
            request.headers().set(HttpHeaders.HOST, (Object)authority);
        } else {
            headers2.remove(HttpHeaders.TRANSFER_ENCODING);
        }
        if (chunked) {
            HttpUtil.setTransferEncodingChunked(request, true);
        }
        if (this.options.isTryUseCompression() && request.headers().get(HttpHeaders.ACCEPT_ENCODING) == null) {
            CharSequence acceptEncoding = Http1xClientConnection.determineCompressionAcceptEncoding();
            request.headers().set(HttpHeaders.ACCEPT_ENCODING, (Object)acceptEncoding);
        }
        if (!this.options.isKeepAlive() && this.options.getProtocolVersion() == HttpVersion.HTTP_1_1) {
            request.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.CLOSE);
        } else if (this.options.isKeepAlive() && this.options.getProtocolVersion() == HttpVersion.HTTP_1_0) {
            request.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.KEEP_ALIVE);
        }
        if (end) {
            request = buf != null ? new AssembledFullHttpRequest(request, buf) : new AssembledFullHttpRequest(request);
        } else if (buf != null) {
            request = new AssembledHttpRequest(request, buf);
        }
        return request;
    }

    static CharSequence determineCompressionAcceptEncoding() {
        if (Http1xClientConnection.isBrotliAvailable()) {
            return HttpHeaders.DEFLATE_GZIP_BR;
        }
        return HttpHeaders.DEFLATE_GZIP;
    }

    private static boolean isBrotliAvailable() {
        return Brotli.isAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginRequest(Stream stream, HttpRequestHead request, boolean chunked, ByteBuf buf, boolean end, boolean connect, Handler<AsyncResult<Void>> handler) {
        request.id = stream.id;
        request.remoteAddress = this.remoteAddress();
        Stream stream2 = stream;
        stream2.bytesWritten = stream2.bytesWritten + (buf != null ? (long)buf.readableBytes() : 0L);
        HttpRequest nettyRequest = this.createRequest(request.method, request.uri, request.headers, request.authority, chunked, buf, end);
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            VertxTracer tracer;
            this.responses.add(stream);
            this.isConnect = connect;
            if (this.metrics != null) {
                stream.metric = this.metrics.requestBegin(request.uri, request);
            }
            if ((tracer = this.context.tracer()) != null) {
                BiConsumer<String, String> headers2 = (key, val) -> nettyRequest.headers().add((String)key, val);
                String operation = request.traceOperation;
                if (operation == null) {
                    operation = request.method.name();
                }
                stream.trace = tracer.sendRequest(stream.context, SpanKind.RPC, this.options.getTracingPolicy(), request, operation, headers2, HttpUtils.CLIENT_HTTP_REQUEST_TAG_EXTRACTOR);
            }
        }
        this.writeToChannel((Object)nettyRequest, handler == null ? null : this.context.promise(handler));
        if (end) {
            this.endRequest(stream);
        }
    }

    private void writeBuffer(Stream s2, ByteBuf buff, boolean end, FutureListener<Void> listener) {
        ReferenceCounted msg;
        Stream stream = s2;
        stream.bytesWritten = stream.bytesWritten + (buff != null ? (long)buff.readableBytes() : 0L);
        if (this.isConnect) {
            ByteBuf byteBuf = msg = buff != null ? buff : Unpooled.EMPTY_BUFFER;
            if (end) {
                this.writeToChannel((Object)msg, this.channelFuture().addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)listener).addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)v -> this.close())));
            } else {
                this.writeToChannel(msg);
            }
        } else {
            msg = end ? (buff != null && buff.isReadable() ? new DefaultLastHttpContent(buff, false) : LastHttpContent.EMPTY_LAST_CONTENT) : new DefaultHttpContent(buff);
            this.writeToChannel((Object)msg, listener);
            if (end) {
                this.endRequest(s2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endRequest(Stream s2) {
        boolean checkLifecycle;
        Stream next;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            this.requests.pop();
            next = this.requests.peek();
            checkLifecycle = s2.responseEnded;
            if (this.metrics != null) {
                this.metrics.requestEnd(s2.metric, s2.bytesWritten);
            }
        }
        this.flushBytesWritten();
        if (next != null) {
            next.promise.complete((HttpClientStream)((Object)next));
        }
        if (checkLifecycle) {
            this.checkLifecycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reset(Stream stream) {
        boolean isInflight;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            this.close = isInflight = this.responses.remove(stream) || this.requests.remove(stream) && stream.responseEnded;
        }
        this.checkLifecycle();
        return !isInflight;
    }

    private void receiveBytes(int len) {
        boolean gt;
        boolean le = this.readWindow <= this.highWaterMark;
        this.readWindow += (long)len;
        boolean bl = gt = this.readWindow > this.highWaterMark;
        if (le && gt) {
            this.doPause();
        }
    }

    private void ackBytes(int len) {
        EventLoop eventLoop = this.context.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            boolean le;
            boolean gt = this.readWindow > this.lowWaterMark;
            this.readWindow -= (long)len;
            boolean bl = le = this.readWindow <= this.lowWaterMark;
            if (gt && le) {
                this.doResume();
            }
        } else {
            eventLoop.execute(() -> this.ackBytes(len));
        }
    }

    private void checkLifecycle() {
        if (this.close || this.shutdown && this.requests.isEmpty() && this.responses.isEmpty()) {
            this.close();
        } else if (!this.isConnect) {
            this.expirationTimestamp = Http1xClientConnection.expirationTimestampOf(this.keepAliveTimeout);
        }
    }

    @Override
    public Future<Void> close() {
        if (!this.evicted) {
            this.evicted = true;
            if (this.evictionHandler != null) {
                this.evictionHandler.handle(null);
            }
        }
        return super.close();
    }

    private Throwable validateMessage(Object msg) {
        if (msg instanceof HttpObject) {
            io.netty.handler.codec.http.HttpVersion version;
            HttpObject obj = (HttpObject)msg;
            DecoderResult result = obj.decoderResult();
            if (result.isFailure()) {
                return result.cause();
            }
            if (obj instanceof HttpResponse && (version = ((HttpResponse)obj).protocolVersion()) != io.netty.handler.codec.http.HttpVersion.HTTP_1_0 && version != io.netty.handler.codec.http.HttpVersion.HTTP_1_1) {
                return new IllegalStateException("Unsupported HTTP version: " + version);
            }
        }
        return null;
    }

    @Override
    public void handleMessage(Object msg) {
        Throwable error = this.validateMessage(msg);
        if (error != null) {
            ReferenceCountUtil.release(msg);
            this.fail(error);
        } else if (msg instanceof HttpObject) {
            this.handleHttpMessage((HttpObject)msg);
        } else if (msg instanceof ByteBuf && this.isConnect) {
            this.handleChunk((ByteBuf)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWsFrame((WebSocketFrame)msg);
        } else {
            this.invalidMessageHandler.handle(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHttpMessage(HttpObject obj) {
        Stream stream;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            stream = this.responses.peekFirst();
        }
        if (stream == null) {
            this.fail(new VertxException("Received HTTP message with no request in progress"));
        } else if (obj instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)obj;
            HttpVersion version = response.protocolVersion() == io.netty.handler.codec.http.HttpVersion.HTTP_1_0 ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
            this.handleResponseBegin(stream, new HttpResponseHead(version, response.status().code(), response.status().reasonPhrase(), new HeadersAdaptor(response.headers())));
        } else if (obj instanceof HttpContent) {
            HttpContent chunk = (HttpContent)obj;
            if (chunk.content().isReadable()) {
                this.handleResponseChunk(stream, chunk.content());
            }
            if (!this.isConnect && chunk instanceof LastHttpContent) {
                this.handleResponseEnd(stream, (LastHttpContent)chunk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChunk(ByteBuf chunk) {
        Stream stream;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            stream = this.responses.peekFirst();
            if (stream == null) {
                return;
            }
        }
        if (chunk.isReadable()) {
            this.handleResponseChunk(stream, chunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponseBegin(Stream stream, HttpResponseHead response) {
        if (response.statusCode == 100) {
            stream.context.execute(null, v -> stream.handleContinue());
        } else {
            HttpRequestHead request;
            Http1xClientConnection http1xClientConnection = this;
            synchronized (http1xClientConnection) {
                request = ((StreamImpl)stream).request;
                stream.response = response;
                if (this.metrics != null) {
                    this.metrics.responseBegin(stream.metric, response);
                }
                if (response.statusCode != 100 && request.method != HttpMethod.CONNECT) {
                    int timeout;
                    String requestConnectionHeader;
                    String responseConnectionHeader = response.headers.get(HttpHeaderNames.CONNECTION);
                    String string = requestConnectionHeader = request.headers != null ? request.headers.get(HttpHeaderNames.CONNECTION) : null;
                    if (HttpHeaderValues.CLOSE.contentEqualsIgnoreCase(responseConnectionHeader) || HttpHeaderValues.CLOSE.contentEqualsIgnoreCase(requestConnectionHeader)) {
                        this.close = true;
                    } else if (response.version == HttpVersion.HTTP_1_0 && !HttpHeaderValues.KEEP_ALIVE.contentEqualsIgnoreCase(responseConnectionHeader)) {
                        this.close = true;
                    }
                    String keepAliveHeader = response.headers.get(HttpHeaderNames.KEEP_ALIVE);
                    if (keepAliveHeader != null && (timeout = HttpUtils.parseKeepAliveHeaderTimeout(keepAliveHeader)) != -1) {
                        this.keepAliveTimeout = timeout;
                    }
                }
            }
            stream.handleHead(response);
            if (this.isConnect) {
                if (request.method == HttpMethod.CONNECT && response.statusCode == 200 || request.method == HttpMethod.GET && request.headers != null && request.headers.contains(HttpHeaders.CONNECTION, HttpHeaders.UPGRADE, true) && response.statusCode == 101) {
                    this.removeChannelHandlers();
                } else {
                    this.isConnect = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChannelHandlers() {
        ChannelPipeline pipeline = this.chctx.pipeline();
        HttpContentDecompressor inflater = pipeline.get(HttpContentDecompressor.class);
        if (inflater != null) {
            pipeline.remove(inflater);
        }
        Handler<Object> prev = this.invalidMessageHandler;
        this.invalidMessageHandler = msg -> ReferenceCountUtil.release(msg);
        try {
            pipeline.remove("codec");
        }
        finally {
            this.invalidMessageHandler = prev;
        }
    }

    private void handleResponseChunk(Stream stream, ByteBuf chunk) {
        Buffer buff = Buffer.buffer(VertxHandler.safeBuffer(chunk));
        int len = buff.length();
        this.receiveBytes(len);
        Stream stream2 = stream;
        stream2.bytesRead = stream2.bytesRead + (long)len;
        stream.context.execute(buff, stream::handleChunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponseEnd(Stream stream, LastHttpContent trailer) {
        boolean check;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (stream.response == null) {
                return;
            }
            this.responses.pop();
            this.close |= !this.options.isKeepAlive();
            stream.responseEnded = true;
            check = this.requests.peek() != stream;
        }
        VertxTracer tracer = this.context.tracer();
        if (tracer != null) {
            tracer.receiveResponse(stream.context, stream.response, stream.trace, null, HttpUtils.CLIENT_RESPONSE_TAG_EXTRACTOR);
        }
        if (this.metrics != null) {
            this.metrics.responseEnd(stream.metric, stream.bytesRead);
        }
        this.flushBytesRead();
        if (check) {
            this.checkLifecycle();
        }
        this.lastResponseReceivedTimestamp = System.currentTimeMillis();
        stream.context.execute(trailer, stream::handleEnd);
    }

    @Override
    public HttpClientMetrics metrics() {
        return this.client.metrics();
    }

    synchronized void toWebSocket(ContextInternal context, String requestURI, MultiMap headers2, boolean allowOriginHeader, WebsocketVersion vers, List<String> subProtocols, long handshakeTimeout, int maxWebSocketFrameSize, Promise<WebSocket> promise) {
        try {
            DefaultHttpHeaders nettyHeaders;
            URI wsuri = new URI(requestURI);
            if (!wsuri.isAbsolute()) {
                wsuri = new URI((this.ssl ? "https:" : "http:") + "//" + this.server.host() + ":" + this.server.port() + requestURI);
            }
            WebSocketVersion version = WebSocketVersion.valueOf((vers == null ? WebSocketVersion.V13 : vers).toString());
            if (headers2 != null) {
                nettyHeaders = new DefaultHttpHeaders();
                for (Map.Entry entry : headers2) {
                    ((io.netty.handler.codec.http.HttpHeaders)nettyHeaders).add((String)entry.getKey(), entry.getValue());
                }
            } else {
                nettyHeaders = null;
            }
            long timer = handshakeTimeout > 0L ? this.vertx.setTimer(handshakeTimeout, id -> this.close()) : -1L;
            ChannelPipeline p = this.chctx.channel().pipeline();
            ArrayList<WebSocketClientExtensionHandshaker> extensionHandshakers = this.initializeWebSocketExtensionHandshakers(this.client.options());
            if (!extensionHandshakers.isEmpty()) {
                p.addBefore("handler", "webSocketsExtensionsHandler", new WebSocketClientExtensionHandler(extensionHandshakers.toArray(new WebSocketClientExtensionHandshaker[0])));
            }
            String subp = null;
            if (subProtocols != null) {
                subp = String.join((CharSequence)",", subProtocols);
            }
            WebSocketClientHandshaker handshaker = Http1xClientConnection.newHandshaker(wsuri, version, subp, !extensionHandshakers.isEmpty(), allowOriginHeader, nettyHeaders, maxWebSocketFrameSize, !this.options.isSendUnmaskedFrames());
            WebSocketHandshakeInboundHandler handshakeInboundHandler = new WebSocketHandshakeInboundHandler(handshaker, ar -> {
                if (timer > 0L) {
                    this.vertx.cancelTimer(timer);
                }
                AsyncResult<Function<HeadersAdaptor, WebSocket>> wsRes = ar.map(v -> {
                    WebSocketImpl w = new WebSocketImpl(context, this, version != WebSocketVersion.V00, this.options.getWebSocketClosingTimeout(), this.options.getMaxWebSocketFrameSize(), this.options.getMaxWebSocketMessageSize());
                    w.subProtocol(handshaker.actualSubprotocol());
                    return w;
                });
                if (ar.failed()) {
                    this.close();
                } else {
                    this.webSocket = (WebSocketImpl)((Object)wsRes.result());
                    ((WebSocketImpl)this.webSocket).registerHandler(this.vertx.eventBus());
                    log.debug("WebSocket handshake complete");
                    HttpClientMetrics metrics = this.client.metrics();
                    if (metrics != null) {
                        ((WebSocketImpl)this.webSocket).setMetric(metrics.connected((WebSocket)((Object)this.webSocket)));
                    }
                }
                this.getContext().emit(wsRes, res -> {
                    if (res.succeeded()) {
                        ((WebSocketImpl)this.webSocket).headers((MultiMap)ar.result());
                    }
                    promise.handle((AsyncResult<WebSocket>)res);
                    if (res.succeeded()) {
                        ((WebSocketImpl)this.webSocket).headers(null);
                    }
                });
            });
            p.addBefore("handler", "handshakeCompleter", handshakeInboundHandler);
            handshaker.handshake(this.chctx.channel());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    static WebSocketClientHandshaker newHandshaker(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, final boolean allowOriginHeader, io.netty.handler.codec.http.HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking) {
        final WebSocketDecoderConfig config = WebSocketDecoderConfig.newBuilder().expectMaskedFrames(false).allowExtensions(allowExtensions).maxFramePayloadLength(maxFramePayloadLength).allowMaskMismatch(false).closeOnProtocolViolation(false).build();
        if (version == WebSocketVersion.V13) {
            return new WebSocketClientHandshaker13(webSocketURL, WebSocketVersion.V13, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, false, -1L){

                @Override
                protected WebSocketFrameDecoder newWebsocketDecoder() {
                    return new WebSocket13FrameDecoder(config);
                }

                @Override
                protected FullHttpRequest newHandshakeRequest() {
                    FullHttpRequest request = super.newHandshakeRequest();
                    if (!allowOriginHeader) {
                        request.headers().remove(HttpHeaders.ORIGIN);
                    }
                    return request;
                }
            };
        }
        if (version == WebSocketVersion.V08) {
            return new WebSocketClientHandshaker08(webSocketURL, WebSocketVersion.V08, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, false, -1L){

                @Override
                protected WebSocketFrameDecoder newWebsocketDecoder() {
                    return new WebSocket08FrameDecoder(config);
                }

                @Override
                protected FullHttpRequest newHandshakeRequest() {
                    FullHttpRequest request = super.newHandshakeRequest();
                    if (!allowOriginHeader) {
                        request.headers().remove(HttpHeaderNames.SEC_WEBSOCKET_ORIGIN);
                    }
                    return request;
                }
            };
        }
        if (version == WebSocketVersion.V07) {
            return new WebSocketClientHandshaker07(webSocketURL, WebSocketVersion.V07, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, false, -1L){

                @Override
                protected WebSocketFrameDecoder newWebsocketDecoder() {
                    return new WebSocket07FrameDecoder(config);
                }

                @Override
                protected FullHttpRequest newHandshakeRequest() {
                    FullHttpRequest request = super.newHandshakeRequest();
                    if (!allowOriginHeader) {
                        request.headers().remove(HttpHeaderNames.SEC_WEBSOCKET_ORIGIN);
                    }
                    return request;
                }
            };
        }
        if (version == WebSocketVersion.V00) {
            return new WebSocketClientHandshaker00(webSocketURL, WebSocketVersion.V00, subprotocol, customHeaders, maxFramePayloadLength, -1L){

                @Override
                protected FullHttpRequest newHandshakeRequest() {
                    FullHttpRequest request = super.newHandshakeRequest();
                    if (!allowOriginHeader) {
                        request.headers().remove(HttpHeaders.ORIGIN);
                    }
                    return request;
                }
            };
        }
        throw new WebSocketHandshakeException("Protocol version " + (Object)((Object)version) + " not supported.");
    }

    ArrayList<WebSocketClientExtensionHandshaker> initializeWebSocketExtensionHandshakers(HttpClientOptions options) {
        ArrayList<WebSocketClientExtensionHandshaker> extensionHandshakers = new ArrayList<WebSocketClientExtensionHandshaker>();
        if (options.getTryWebSocketDeflateFrameCompression()) {
            extensionHandshakers.add(new DeflateFrameClientExtensionHandshaker(options.getWebSocketCompressionLevel(), false));
        }
        if (options.getTryUsePerMessageWebSocketCompression()) {
            extensionHandshakers.add(new PerMessageDeflateClientExtensionHandshaker(options.getWebSocketCompressionLevel(), ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, options.getWebSocketCompressionAllowClientNoContext(), options.getWebSocketCompressionRequestServerNoContext()));
        }
        return extensionHandshakers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInterestedOpsChanged() {
        Handler<Boolean> handler;
        ContextInternal context;
        boolean writable = !this.isNotWritable();
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            Stream current = this.requests.peek();
            if (current != null) {
                context = current.context;
                handler = current::handleWritabilityChanged;
            } else if (this.webSocket != null) {
                context = ((WebSocketImpl)this.webSocket).context;
                handler = ((WebSocketImpl)this.webSocket)::handleWritabilityChanged;
            } else {
                return;
            }
        }
        context.execute(writable, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClosed() {
        ArrayList<Stream> allocatedStreams;
        ArrayList<Stream> sentStreams;
        WebSocketImpl ws;
        super.handleClosed();
        long timerID = this.shutdownTimerID;
        if (timerID != -1L) {
            this.shutdownTimerID = -1L;
            this.vertx.cancelTimer(timerID);
        }
        this.closed = true;
        if (this.metrics != null) {
            HttpClientMetrics met = this.client.metrics();
            met.endpointDisconnected(this.metrics);
        }
        if (!this.evicted) {
            this.evicted = true;
            if (this.evictionHandler != null) {
                this.evictionHandler.handle(null);
            }
        }
        VertxTracer tracer = this.context.tracer();
        Iterator iterator = this;
        synchronized (iterator) {
            ws = (WebSocketImpl)this.webSocket;
            sentStreams = new ArrayList<Stream>(this.responses);
            allocatedStreams = new ArrayList<Stream>(this.requests);
            allocatedStreams.removeAll(this.responses);
        }
        if (ws != null) {
            ws.handleConnectionClosed();
        }
        for (Stream stream : allocatedStreams) {
            stream.context.execute(null, v -> stream.handleClosed());
        }
        for (Stream stream : sentStreams) {
            if (this.metrics != null) {
                this.metrics.requestReset(stream.metric);
            }
            Object trace = stream.trace;
            if (tracer != null && trace != null) {
                tracer.receiveResponse(stream.context, null, trace, HttpUtils.CLOSED_EXCEPTION, TagExtractor.empty());
            }
            stream.context.execute(null, v -> stream.handleClosed());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleIdle(IdleStateEvent event) {
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (this.webSocket == null && this.responses.isEmpty() && this.requests.isEmpty()) {
                return;
            }
        }
        super.handleIdle(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleException(Throwable e) {
        WebSocketImpl ws;
        super.handleException(e);
        LinkedHashSet<Stream> allStreams = new LinkedHashSet<Stream>();
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            ws = (WebSocketImpl)this.webSocket;
            allStreams.addAll(this.requests);
            allStreams.addAll(this.responses);
        }
        if (ws != null) {
            ws.handleException(e);
        }
        for (Stream stream : allStreams) {
            stream.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createStream(ContextInternal context, Handler<AsyncResult<HttpClientStream>> handler) {
        EventLoop eventLoop = context.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            StreamImpl stream;
            Http1xClientConnection http1xClientConnection = this;
            synchronized (http1xClientConnection) {
                if (this.closed) {
                    stream = null;
                } else {
                    stream = new StreamImpl(context, this, this.seq++);
                    this.requests.add(stream);
                    if (this.requests.size() == 1) {
                        stream.promise.complete(stream);
                    }
                }
            }
            if (stream != null) {
                stream.promise.future().onComplete(handler);
            } else {
                handler.handle(Future.failedFuture(HttpUtils.CLOSED_EXCEPTION));
            }
        } else {
            eventLoop.execute(() -> this.createStream(context, handler));
        }
    }

    @Override
    public long lastResponseReceivedTimestamp() {
        return this.lastResponseReceivedTimestamp;
    }

    @Override
    public boolean isValid() {
        return this.expirationTimestamp == 0L || System.currentTimeMillis() <= this.expirationTimestamp;
    }

    @Override
    public void shutdown(long timeout, Handler<AsyncResult<Void>> handler) {
        this.shutdown(timeout, this.vertx.promise(handler));
    }

    @Override
    public Future<Void> shutdown(long timeoutMs) {
        PromiseInternal<Void> promise = this.vertx.promise();
        this.shutdown(timeoutMs, promise);
        return promise.future();
    }

    private synchronized void shutdownNow() {
        this.shutdownTimerID = -1L;
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(long timeoutMs, PromiseInternal<Void> promise) {
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (this.shutdown) {
                promise.fail("Already shutdown");
                return;
            }
            this.shutdown = true;
            this.closeFuture().onComplete(promise);
        }
        http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (!this.closed) {
                if (timeoutMs > 0L) {
                    this.shutdownTimerID = this.context.setTimer(timeoutMs, id -> this.shutdownNow());
                } else {
                    this.close = true;
                }
            }
        }
        this.checkLifecycle();
    }

    private static long expirationTimestampOf(long timeout) {
        return timeout == 0L ? 0L : System.currentTimeMillis() + timeout * 1000L;
    }

    private static class StreamImpl
    extends Stream
    implements HttpClientStream {
        private final Http1xClientConnection conn;
        private final InboundBuffer<Object> queue;
        private boolean reset;
        private boolean closed;
        private HttpRequestHead request;
        private Handler<HttpResponseHead> headHandler;
        private Handler<Buffer> chunkHandler;
        private Handler<MultiMap> endHandler;
        private Handler<Void> drainHandler;
        private Handler<Void> continueHandler;
        private Handler<Throwable> exceptionHandler;
        private Handler<Void> closeHandler;

        StreamImpl(ContextInternal context, Http1xClientConnection conn, int id) {
            super(context, id);
            this.conn = conn;
            this.queue = new InboundBuffer<Object>(context, 5L).handler(item -> {
                if (item instanceof MultiMap) {
                    Handler<MultiMap> handler = this.endHandler;
                    if (handler != null) {
                        handler.handle((MultiMap)item);
                    }
                } else {
                    Buffer buffer = (Buffer)item;
                    int len = buffer.length();
                    conn.ackBytes(len);
                    Handler<Buffer> handler = this.chunkHandler;
                    if (handler != null) {
                        handler.handle(buffer);
                    }
                }
            }).exceptionHandler(context::reportException);
        }

        @Override
        public void continueHandler(Handler<Void> handler) {
            this.continueHandler = handler;
        }

        public StreamImpl drainHandler(Handler<Void> handler) {
            this.drainHandler = handler;
            return this;
        }

        @Override
        public StreamImpl exceptionHandler(Handler<Throwable> handler) {
            this.exceptionHandler = handler;
            return this;
        }

        @Override
        public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
            return null;
        }

        @Override
        public boolean writeQueueFull() {
            return false;
        }

        @Override
        public void headHandler(Handler<HttpResponseHead> handler) {
            this.headHandler = handler;
        }

        @Override
        public void closeHandler(Handler<Void> handler) {
            this.closeHandler = handler;
        }

        @Override
        public void priorityHandler(Handler<StreamPriority> handler) {
        }

        @Override
        public void pushHandler(Handler<HttpClientPush> handler) {
        }

        @Override
        public void unknownFrameHandler(Handler<HttpFrame> handler) {
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public Object metric() {
            return super.metric();
        }

        @Override
        public HttpVersion version() {
            return this.conn.version;
        }

        @Override
        public HttpClientConnection connection() {
            return this.conn;
        }

        @Override
        public ContextInternal getContext() {
            return this.context;
        }

        @Override
        public void writeHead(HttpRequestHead request, boolean chunked, ByteBuf buf, boolean end, StreamPriority priority, boolean connect, Handler<AsyncResult<Void>> handler) {
            this.writeHead(request, chunked, buf, end, connect, handler == null ? null : this.context.promise(handler));
        }

        private void writeHead(HttpRequestHead request, boolean chunked, ByteBuf buf, boolean end, boolean connect, Handler<AsyncResult<Void>> handler) {
            EventLoop eventLoop = this.conn.context.nettyEventLoop();
            if (eventLoop.inEventLoop()) {
                this.request = request;
                this.conn.beginRequest(this, request, chunked, buf, end, connect, handler);
            } else {
                eventLoop.execute(() -> this.writeHead(request, chunked, buf, end, connect, handler));
            }
        }

        @Override
        public void writeBuffer(ByteBuf buff, boolean end, Handler<AsyncResult<Void>> handler) {
            if (buff != null || end) {
                PromiseInternal<Void> listener = handler == null ? null : this.context.promise(handler);
                this.writeBuffer(buff, end, (FutureListener<Void>)listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeBuffer(ByteBuf buff, boolean end, FutureListener<Void> listener) {
            EventLoop eventLoop;
            FutureListener l;
            if (buff != null) {
                int size = buff.readableBytes();
                l = future -> {
                    Handler<Void> drain;
                    Http1xClientConnection http1xClientConnection = this.conn;
                    synchronized (http1xClientConnection) {
                        Http1xClientConnection http1xClientConnection2 = this.conn;
                        http1xClientConnection2.writeWindow = http1xClientConnection2.writeWindow - (long)size;
                        if (this.conn.writeOverflow && this.conn.writeWindow < this.conn.lowWaterMark) {
                            drain = this.drainHandler;
                            this.conn.writeOverflow = false;
                        } else {
                            drain = null;
                        }
                    }
                    if (drain != null) {
                        this.context.emit(drain);
                    }
                    if (listener != null) {
                        listener.operationComplete(future);
                    }
                };
                Http1xClientConnection http1xClientConnection = this.conn;
                synchronized (http1xClientConnection) {
                    Http1xClientConnection http1xClientConnection2 = this.conn;
                    http1xClientConnection2.writeWindow = http1xClientConnection2.writeWindow + (long)size;
                    if (this.conn.writeWindow > this.conn.highWaterMark) {
                        this.conn.writeOverflow = true;
                    }
                }
            } else {
                l = listener;
            }
            if ((eventLoop = this.conn.context.nettyEventLoop()).inEventLoop()) {
                this.conn.writeBuffer(this, buff, end, l);
            } else {
                eventLoop.execute(() -> this.writeBuffer(buff, end, l));
            }
        }

        @Override
        public void writeFrame(int type, int flags, ByteBuf payload) {
            throw new IllegalStateException("Cannot write an HTTP/2 frame over an HTTP/1.x connection");
        }

        @Override
        public void doSetWriteQueueMaxSize(int size) {
            this.conn.doSetWriteQueueMaxSize(size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isNotWritable() {
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                return this.conn.writeWindow > this.conn.highWaterMark;
            }
        }

        @Override
        public void doPause() {
            this.queue.pause();
        }

        @Override
        public void doFetch(long amount) {
            this.queue.fetch(amount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset(Throwable cause) {
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                if (this.reset) {
                    return;
                }
                this.reset = true;
            }
            EventLoop eventLoop = this.conn.context.nettyEventLoop();
            if (eventLoop.inEventLoop()) {
                this._reset(cause);
            } else {
                eventLoop.execute(() -> this._reset(cause));
            }
        }

        private void _reset(Throwable cause) {
            boolean removed = this.conn.reset(this);
            this.context.execute(cause, this::handleException);
            if (removed) {
                this.context.execute(this::handleClosed);
            }
        }

        @Override
        public StreamPriority priority() {
            return null;
        }

        @Override
        public void updatePriority(StreamPriority streamPriority) {
        }

        @Override
        void handleWritabilityChanged(boolean writable) {
        }

        @Override
        void handleContinue() {
            if (this.continueHandler != null) {
                this.continueHandler.handle(null);
            }
        }

        @Override
        void handleHead(HttpResponseHead response) {
            Handler<HttpResponseHead> handler = this.headHandler;
            if (handler != null) {
                this.context.emit(response, handler);
            }
        }

        @Override
        public void chunkHandler(Handler<Buffer> handler) {
            this.chunkHandler = handler;
        }

        @Override
        public void endHandler(Handler<MultiMap> handler) {
            this.endHandler = handler;
        }

        @Override
        void handleChunk(Buffer buff) {
            this.queue.write(buff);
        }

        @Override
        void handleEnd(LastHttpContent trailer) {
            this.queue.write((Object)new HeadersAdaptor(trailer.trailingHeaders()));
            this.tryClose();
        }

        @Override
        void handleException(Throwable cause) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(cause);
            }
        }

        @Override
        void handleClosed() {
            this.handleException(HttpUtils.CLOSED_EXCEPTION);
            this.tryClose();
        }

        private void tryClose() {
            if (!this.closed) {
                this.closed = true;
                if (this.closeHandler != null) {
                    this.closeHandler.handle(null);
                }
            }
        }
    }

    private static abstract class Stream {
        protected final Promise<HttpClientStream> promise;
        protected final ContextInternal context;
        protected final int id;
        private Object trace;
        private Object metric;
        private HttpResponseHead response;
        private boolean responseEnded;
        private long bytesRead;
        private long bytesWritten;

        Stream(ContextInternal context, int id) {
            this.context = context;
            this.id = id;
            this.promise = context.promise();
        }

        Object metric() {
            return this.metric;
        }

        abstract void handleContinue();

        abstract void handleHead(HttpResponseHead var1);

        abstract void handleChunk(Buffer var1);

        abstract void handleEnd(LastHttpContent var1);

        abstract void handleWritabilityChanged(boolean var1);

        abstract void handleException(Throwable var1);

        abstract void handleClosed();
    }
}

