/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.trace;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.internal.ReadOnlyArrayMap;
import io.opentelemetry.api.trace.ArrayBasedTraceStateBuilder;
import io.opentelemetry.api.trace.AutoValue_ArrayBasedTraceState;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.TraceStateBuilder;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
abstract class ArrayBasedTraceState
implements TraceState {
    @Override
    @Nullable
    public String get(String key) {
        if (key == null) {
            return null;
        }
        List<String> entries = this.getEntries();
        for (int i2 = 0; i2 < entries.size(); i2 += 2) {
            if (!entries.get(i2).equals(key)) continue;
            return entries.get(i2 + 1);
        }
        return null;
    }

    @Override
    public int size() {
        return this.getEntries().size() / 2;
    }

    @Override
    public boolean isEmpty() {
        return this.getEntries().isEmpty();
    }

    @Override
    public void forEach(BiConsumer<String, String> consumer) {
        if (consumer == null) {
            return;
        }
        List<String> entries = this.getEntries();
        for (int i2 = 0; i2 < entries.size(); i2 += 2) {
            consumer.accept(entries.get(i2), entries.get(i2 + 1));
        }
    }

    @Override
    public Map<String, String> asMap() {
        return ReadOnlyArrayMap.wrap(this.getEntries());
    }

    abstract List<String> getEntries();

    @Override
    public TraceStateBuilder toBuilder() {
        return new ArrayBasedTraceStateBuilder(this);
    }

    static ArrayBasedTraceState create(List<String> entries) {
        return new AutoValue_ArrayBasedTraceState(entries);
    }

    ArrayBasedTraceState() {
    }
}

