/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.voice.aliyun;

import javax.annotation.Nonnull;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.community.notify.DefaultNotifyType;
import org.jetlinks.community.notify.NotifierProperties;
import org.jetlinks.community.notify.NotifierProvider;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.Provider;
import org.jetlinks.community.notify.template.TemplateManager;
import org.jetlinks.community.notify.template.TemplateProperties;
import org.jetlinks.community.notify.template.TemplateProvider;
import org.jetlinks.community.notify.voice.VoiceProvider;
import org.jetlinks.community.notify.voice.aliyun.AliyunVoiceNotifier;
import org.jetlinks.community.notify.voice.aliyun.AliyunVoiceTemplate;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.StringType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class AliyunNotifierProvider
implements NotifierProvider,
TemplateProvider {
    private static final Logger log = LoggerFactory.getLogger(AliyunNotifierProvider.class);
    private TemplateManager templateManager;
    public static final DefaultConfigMetadata templateConfig = new DefaultConfigMetadata("\u963f\u91cc\u4e91\u8bed\u97f3\u6a21\u7248", "https://help.aliyun.com/document_detail/114035.html?spm=a2c4g.11186623.6.561.3d1b3c2dGMXAmk").add("ttsCode", "\u6a21\u7248ID", "ttsCode", (DataType)new StringType()).add("calledShowNumbers", "\u88ab\u53eb\u663e\u53f7", "", (DataType)new StringType()).add("CalledNumber", "\u88ab\u53eb\u53f7\u7801", "", (DataType)new StringType()).add("PlayTimes", "\u64ad\u653e\u6b21\u6570", "", (DataType)new IntType());
    public static final DefaultConfigMetadata notifierConfig = new DefaultConfigMetadata("\u963f\u91cc\u4e91\u901a\u77e5\u914d\u7f6e", "https://help.aliyun.com/document_detail/114035.html?spm=a2c4g.11186623.6.561.3d1b3c2dGMXAmk").add("regionId", "regionId", "regionId", (DataType)new StringType()).add("accessKeyId", "accessKeyId", "", (DataType)new StringType()).add("secret", "secret", "", (DataType)new StringType());

    @Nonnull
    public Provider getProvider() {
        return VoiceProvider.aliyun;
    }

    public ConfigMetadata getTemplateConfigMetadata() {
        return templateConfig;
    }

    public ConfigMetadata getNotifierConfigMetadata() {
        return notifierConfig;
    }

    public Mono<AliyunVoiceTemplate> createTemplate(TemplateProperties properties) {
        return (Mono)Mono.fromCallable(() -> (AliyunVoiceTemplate)((AliyunVoiceTemplate)new AliyunVoiceTemplate().with(properties)).validate()).as(LocaleUtils::transform);
    }

    @Nonnull
    public NotifyType getType() {
        return DefaultNotifyType.voice;
    }

    @Nonnull
    public Mono<AliyunVoiceNotifier> createNotifier(@Nonnull NotifierProperties properties) {
        return (Mono)Mono.fromSupplier(() -> new AliyunVoiceNotifier(properties, this.templateManager)).as(LocaleUtils::transform);
    }

    public AliyunNotifierProvider(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }
}

