package com.artfess.yhxt.tree.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.check.regular.model.BridgeOftenCheck;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.tree.model.TreeDictionary;
import com.artfess.yhxt.tree.manager.TreeDictionaryManager;

import java.util.HashMap;

/**
 * 树形字典表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 超级管理员
 * @since 2021-08-04
 */
@RestController
@RequestMapping("/treeDictionary/v1/")
@Api(tags = "树形字典接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class TreeDictionaryController extends BaseController<TreeDictionaryManager, TreeDictionary> {


    @RequestMapping(value="getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询树形字典",httpMethod = "POST")
    public PageList<TreeDictionary> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<TreeDictionary> queryFilter) {
        PageList<TreeDictionary> pageList = baseService.query(queryFilter);
        return  pageList;
    }

    @RequestMapping(value = "/saveBridge", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改字典", httpMethod = "POST")
    public CommonResult<String> saveBridge(@ApiParam(name = "treeDictionary", value = "树形字典对象") @RequestBody TreeDictionary treeDictionary) throws Exception {
        String msg = "添加成功";
        baseService.checkNumber(treeDictionary);
        if (StringUtils.isEmpty(treeDictionary.getId())) {
            treeDictionary.setSn(baseService.getSn());
            baseService.create(treeDictionary);
        } else {
            baseService.update(treeDictionary);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }


    @RequestMapping(value = "/updateBySn", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改排序号", httpMethod = "POST")
    public CommonResult<String> updateBySn(@ApiParam(name = "params", value = "排序参数：Key：ID，Value：排序号") @RequestBody HashMap<String, Integer> params) throws Exception {
        baseService.updateSequence(params);
        return new CommonResult<>(true, "排序完成");
    }

    @DeleteMapping(value = "/remove")
    @ApiOperation(value = "批量删除树形字典记录", httpMethod = "DELETE", notes = "批量删除树形字典记录")
    public CommonResult<String> remove(@ApiParam(name = "ids", value = "业务主键数组,多个业务主键之间用逗号分隔", required = true) @PathVariable String... ids) throws Exception {
        baseService.removeByIds(ids);
        return new CommonResult<String>(true, "删除成功");
    }
}
