package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.file.util.MinioUtil;
import com.artfess.yhxt.specialproject.manager.BizEngineeringAccessoriesManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.model.BizProjectBidding;
import com.artfess.yhxt.specialproject.dao.BizProjectBiddingDao;
import com.artfess.yhxt.specialproject.manager.BizProjectBiddingManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialproject.model.BizProjectBidding;
import com.artfess.yhxt.specialproject.model.BizProjectBidding;
import com.artfess.yhxt.specialproject.vo.BizProjectBiddingVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.List;
import java.util.UUID;

/**
 * 项目招投标信息表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-17
 */
@Service
public class BizProjectBiddingManagerImpl extends BaseManagerImpl<BizProjectBiddingDao, BizProjectBidding> implements BizProjectBiddingManager {

    @Resource
    private BizEngineeringAccessoriesManager bizEngineeringAccessoriesManager;

    @Override
    public PageList<BizProjectBidding> queryBizProjectBidding(QueryFilter<BizProjectBidding> queryFilter) {
        IPage<BizProjectBidding> result = baseMapper.queryBizProjectBidding(convert2IPage(queryFilter.getPageBean()),convert2Wrapper(queryFilter,currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizProjectBidding getBizProjectBiddingById(String id) {
        BizProjectBidding bizProjectBidding = baseMapper.selectById(id);
        return bizProjectBidding;
    }

    @Override
    public String minioUpload(MultipartFile file) {
        String miniourl = MinioUtil.getMinioUrl();
        if (file.isEmpty() || file.getSize() == 0) {
            throw new RuntimeException("文件为空");
        }
        String fileName = file.getOriginalFilename();
        String name = DigestUtils.md5Hex(UUID.randomUUID().toString()) + fileName.substring(fileName.lastIndexOf("."));
        String url = null;
        try {
            url = MinioUtil.uploadRelative(file, "/engineering", name, "yhxt");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return miniourl+url;
    }

    @Override
    public void saveVo(BizProjectBiddingVo bizProjectBiddingVo) {
        //招投标
        BizProjectBidding bizProjectBidding = bizProjectBiddingVo.getBizProjectBidding();
        this.create(bizProjectBidding);
        //附件
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizProjectBiddingVo.getBizEngineeringAccessoriesList();
        String sourceId = bizProjectBidding.getId();
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);

    }

    @Override
    public void updateVo(BizProjectBiddingVo bizProjectBiddingVo) {
        //工程项目
        BizProjectBidding bizProjectBidding = bizProjectBiddingVo.getBizProjectBidding();
        this.update(bizProjectBidding);
        String sourceId = bizProjectBidding.getId();
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizProjectBiddingVo.getBizEngineeringAccessoriesList();
        bizEngineeringAccessoriesManager.removeEngineeringAccessories(sourceId);
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);

    }

    @Override
    public BizProjectBiddingVo getVo(String id) {
        BizProjectBiddingVo bizProjectBiddingVo= new BizProjectBiddingVo();
        BizProjectBidding bizProjectBidding = this.getById(id);
        List<BizEngineeringAccessories> engineeringAccessories = this.bizEngineeringAccessoriesManager.getEngineeringAccessoriesBySourceId(id);
        bizProjectBiddingVo.setBizProjectBidding(bizProjectBidding);
        bizProjectBiddingVo.setBizEngineeringAccessoriesList(engineeringAccessories);
        return bizProjectBiddingVo;
    }


}
