package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialcheck.vo.ApplicationForChangeOfContractVo;
import com.artfess.yhxt.specialproject.manager.*;
import com.artfess.yhxt.specialproject.model.*;
import com.artfess.yhxt.specialproject.dao.BizApplicationForChangeOfContractDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialproject.vo.ChangeContractVo;
import com.artfess.yhxt.specialproject.vo.ProjectContractVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

/**
 * 合同变更申请表 服务实现类
 *
 * @author wangping
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-12
 */
@Service
public class BizApplicationForChangeOfContractManagerImpl extends BaseManagerImpl<BizApplicationForChangeOfContractDao, BizApplicationForChangeOfContract> implements BizApplicationForChangeOfContractManager {
    @Resource
    private BizContractChangeInvalidManager bizContractChangeInvalidManager;

    @Resource
    private BizContractDetailChangeInvalidManager bizContractDetailChangeInvalidManager;
    @Resource
    private BizProjectContractManager bizProjectContractManager;
    @Resource
    private BizProjectContractDetailsManager bizProjectContractDetailsManager;
    @Resource
    private BaseContext baseContext;

    @Override
    public PageList<BizApplicationForChangeOfContract> queryBizApplicationForChangeOfContract(QueryFilter<BizApplicationForChangeOfContract> queryFilter) {
        IPage<BizApplicationForChangeOfContract> result = baseMapper.queryBizApplicationForChangeOfContract(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizApplicationForChangeOfContract getBizApplicationForChangeOfContractById(String id) {
        BizApplicationForChangeOfContract bizApplicationForChangeOfContract = baseMapper.selectById(id);
        return bizApplicationForChangeOfContract;
    }

    @Override
    public void saveVo(ApplicationForChangeOfContractVo vo) {
        //变更申请实体
        BizApplicationForChangeOfContract applicationForChangeOfContract = vo.getBizApplicationForChangeOfContract();
        //变更申请人
        applicationForChangeOfContract.setChangeApplyUser(baseContext.getCurrentUserName());
        //变更申请人单位
        applicationForChangeOfContract.setChangeApplyUnit(baseContext.getCurrentOrgName());
        //变更申请人时间
        applicationForChangeOfContract.setChangeApplyDate(LocalDate.now());
        //变更状态
        applicationForChangeOfContract.setChangeConfirmStatus(0);
        this.checkContractId(applicationForChangeOfContract);
        this.saveOrUpdate(applicationForChangeOfContract);
        //合同信息变更表
        BizContractChangeInvalid bizContractChangeInvalid = vo.getBizContractChangeInvalid();
        bizContractChangeInvalid.setContractId(applicationForChangeOfContract.getContractId());
        this.bizContractChangeInvalidManager.saveOrUpdate(bizContractChangeInvalid);
        //合同信息明细变更表
        List<BizContractDetailChangeInvalid> list = vo.getBizContractDetailChangeInvalidList();
        for (BizContractDetailChangeInvalid bizContractDetailChangeInvalid : list) {
            bizContractDetailChangeInvalid.setContractId(applicationForChangeOfContract.getContractId());
        }
        QueryWrapper<BizContractDetailChangeInvalid> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("CONTRACT_ID_", applicationForChangeOfContract.getContractId());
        this.bizContractDetailChangeInvalidManager.getBaseMapper().delete(queryWrapper);
        this.bizContractDetailChangeInvalidManager.saveBatch(list);

    }

    @Override
    public PageList<ProjectContractVo> queryApplicationForChangeOfContractVo(QueryFilter<BizApplicationForChangeOfContract> queryFilter) {
        IPage<ProjectContractVo> result = baseMapper.queryApplicationForChangeOfContractVo(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public ChangeContractVo getChangeContractVoById(String id) {
        ChangeContractVo changeContractVo = new ChangeContractVo();
        QueryWrapper<BizApplicationForChangeOfContract> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("CONTRACT_ID_", id);
        queryWrapper.eq("IS_DELE_", "0");
        List<BizApplicationForChangeOfContract> bizApplicationForChangeOfContracts = this.baseMapper.selectList(queryWrapper);
        if (bizApplicationForChangeOfContracts.size() == 0) {
            return null;
        }
        //合同信息
        BizProjectContract projectContract = this.bizProjectContractManager.getById(id);
        //合同明细表
        QueryWrapper<BizProjectContractDetails> detailsQueryWrapper = new QueryWrapper<>();
        detailsQueryWrapper.eq("CONTRACT_ID_", id);
        detailsQueryWrapper.eq("IS_DELE_", "0");
        List<BizProjectContractDetails> contractDetails = this.bizProjectContractDetailsManager.getBaseMapper().selectList(detailsQueryWrapper);
        //合同变更
        QueryWrapper<BizContractChangeInvalid> invalidQueryWrapper = new QueryWrapper<>();
        invalidQueryWrapper.eq("CONTRACT_ID_", id);
        invalidQueryWrapper.eq("IS_DELE_", "0");
        List<BizContractChangeInvalid> invalidList = this.bizContractChangeInvalidManager.getBaseMapper().selectList(invalidQueryWrapper);
        //合同变更明细
        QueryWrapper<BizContractDetailChangeInvalid> detailInvalidQueryWrapper = new QueryWrapper<>();
        detailInvalidQueryWrapper.eq("CONTRACT_ID_", id);
        detailInvalidQueryWrapper.eq("IS_DELE_", "0");
        List<BizContractDetailChangeInvalid> bizContractDetailChangeInvalids = this.bizContractDetailChangeInvalidManager.getBaseMapper().selectList(detailInvalidQueryWrapper);
        changeContractVo.setBizProjectContract(projectContract);
        changeContractVo.setBizProjectContractDetailsList(contractDetails);
        if (invalidList.size() > 0) {
            changeContractVo.setBizContractChangeInvalid(invalidList.get(0));
        }
        if (bizApplicationForChangeOfContracts.size() > 0) {
            changeContractVo.setBizApplicationForChangeOfContract(bizApplicationForChangeOfContracts.get(0));
        }
        changeContractVo.setBizContractDetailChangeInvalidList(bizContractDetailChangeInvalids);
        return changeContractVo;
    }

    @Override
    @Transactional
    public void synchronousContractData(ChangeContractVo vo) {
        //合同信息
        BizProjectContract bizProjectContract = vo.getBizProjectContract();
        //合同变更信息
        BizContractChangeInvalid bizContractChangeInvalid = vo.getBizContractChangeInvalid();
        //合同明细变更信息
        List<BizContractDetailChangeInvalid> bizContractDetailChangeInvalidList = vo.getBizContractDetailChangeInvalidList();
        //合同变更申请
        BizApplicationForChangeOfContract bizApplicationForChangeOfContract = vo.getBizApplicationForChangeOfContract();
        //1正式变更填写人
        //正式变更填写人
        bizApplicationForChangeOfContract.setChangeExecuteUser(baseContext.getCurrentUserName());
        //正式变更申请人单位
        bizApplicationForChangeOfContract.setChangeExecuteUnit(baseContext.getCurrentOrgName());
        //正式变更申请人时间
        bizApplicationForChangeOfContract.setChangeExecuteDate(LocalDate.now());
        //2.合同变更信息同步到合同信息中
        //合同ID
        String contractId = bizApplicationForChangeOfContract.getContractId();
        if (contractId.equals(bizProjectContract.getId())){
            //合同名称
            String contractName = bizContractChangeInvalid.getContractName();
            if (StringUtils.isNotEmpty(contractName)) {
                bizProjectContract.setContractName(contractName);
            }
            String contractAmount = bizContractChangeInvalid.getContractAmount();
            if (StringUtils.isNotEmpty(contractAmount)) {
                bizProjectContract.setContractAmount(contractAmount);
            }
        }



        //3.同步合同明细表
            //3.1删除原来的合同明细
        if (StringUtils.isEmpty(contractId)) return;
        this.bizProjectContractDetailsManager.removeContract(contractId);

        //合同明细
        List<BizProjectContractDetails> bizProjectContractDetailsList = new ArrayList<>();
        for (BizContractDetailChangeInvalid bizContractDetailChangeInvalid : bizContractDetailChangeInvalidList) {
            BizProjectContractDetails bizProjectContractDetails = new BizProjectContractDetails();
            //合同ID
            bizProjectContractDetails.setContractId(bizContractDetailChangeInvalid.getContractId());
            //科目
            bizProjectContractDetails.setSubjectNumber(bizContractDetailChangeInvalid.getSubSubjectNumber());
            bizProjectContractDetails.setSubjectName(bizContractDetailChangeInvalid.getSubjectName());
            //细科目
            bizProjectContractDetails.setSubSubjectNumber(bizContractDetailChangeInvalid.getSubSubjectNumber());
            bizProjectContractDetails.setSubSubjectName(bizContractDetailChangeInvalid.getSubSubjectName());
            //单价
            bizProjectContractDetails.setSubjectPrice(bizContractDetailChangeInvalid.getSubjectPrice());
            //单位
            bizProjectContractDetails.setSubjectUnit(bizContractDetailChangeInvalid.getSubjectUnit());
            //完成已计量数量
            bizProjectContractDetails.setCompleteAmount(bizContractDetailChangeInvalid.getCompleteAmount());
            //完成已计量金额(元)
            bizProjectContractDetails.setPaidMoney(bizContractDetailChangeInvalid.getPaidMoney());
            //数量
            bizProjectContractDetails.setSubjectAmount(bizContractDetailChangeInvalid.getSubjectAmount());
            //金额（元）
            bizProjectContractDetails.setSubjectMoney(bizContractDetailChangeInvalid.getSubjectMoney());
            //备注
            bizProjectContractDetails.setRemarks(bizContractDetailChangeInvalid.getRemarks());
            bizProjectContractDetailsList.add(bizProjectContractDetails);
        }

        //保存合同信息
        bizProjectContractManager.saveOrUpdate(bizProjectContract);
        //保存合同明细信息
        bizProjectContractDetailsManager.saveOrUpdateBatch(bizProjectContractDetailsList);

        //4审核通过后从合同变更表中删除合同变更信息

    }

    //检查合同是否已经变更
    private void checkContractId(BizApplicationForChangeOfContract bizApplicationForChangeOfContract) {

        QueryWrapper<BizApplicationForChangeOfContract> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("CONTRACT_ID_", bizApplicationForChangeOfContract.getContractId());
        queryWrapper.eq("is_dele_", "0");
        if (StringUtils.isNotBlank(bizApplicationForChangeOfContract.getId())) {
            queryWrapper.notIn("ID_", bizApplicationForChangeOfContract.getId());
        }
        List<BizApplicationForChangeOfContract> list = this.baseMapper.selectList(queryWrapper);
        if (list.size() > 0) {
            throw new RuntimeException("该合同已经修改，请不要重复添加！！！");
        }
    }
}
