package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.query.*;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.dao.RoadDao;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.*;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.statistics.vo.Org4BridgeVO;
import com.artfess.yhxt.statistics.vo.Org4RoadVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service("RoadManager")
public class RoadManagerImpl extends BaseManagerImpl<RoadDao, Road> implements RoadManager {
    @Resource
    RoadDao roadDao;
    @Resource
    private BaseContext baseContext;
    @Resource
    PermissionUtils permissionUtils;

    @Resource
    private OrgDao orgDao;


    @Override
    public List<Org4RoadVO> getRoadCount() {
        String orgId ;
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())&&!"0".equals(baseContext.getCurrentOrgId())){
            orgId = baseContext.getCurrentOrgId();
        }else {
            orgId = "1419863231459102720";
        }
        List<Org4RoadVO> lists = new ArrayList<>();

        List<Org> rtnList = new ArrayList<Org>();

        QueryWrapper<Org> rgQueryWrapper = new QueryWrapper<>();
        rgQueryWrapper.eq("is_dele_","0");
        List<Org> allList = orgDao.selectList(rgQueryWrapper);

        List<Org> list = getOrgChild(allList, orgId, rtnList);
        for (Org org: list){
            Org4RoadVO fvo = new Org4RoadVO();
            BeanUtils.copyProperties(org,fvo);
            lists.add(fvo);
        }
        lists = getChild(lists,orgId);


        return this.setCount(lists);
    }


    public List<Org4RoadVO> setCount(List<Org4RoadVO> list){

        // 获取迭代器
        Iterator<Org4RoadVO> it = list.iterator();

        while(it.hasNext()){
            Org4RoadVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<Road> roadList = new ArrayList<>();
            if (grade<4){
                QueryWrapper<Road> roadQueryWrapper = new QueryWrapper<>();
                roadQueryWrapper.like( "COMPANY_IDS_", orgVO.getId());
                roadList = this.list(roadQueryWrapper);
            }else if (grade==4){
                QueryWrapper<Road> roadByNameQueryWrapper = new QueryWrapper<>();
                roadByNameQueryWrapper.eq("NAME_",orgVO.getName());
                roadList =
                        this.list(roadByNameQueryWrapper);
            }
            if (roadList.size()>0){
                orgVO = this.newCountWorkOrder(roadList,orgVO);
            }else {
                it.remove();
            }
            if (orgVO.getChirldren().size()>0&&Integer.valueOf(orgVO.getGrade())<4){
                this.setCount(orgVO.getChirldren());
            }
        }
        return list;
    }


    //统计表格
    public Org4RoadVO newCountWorkOrder(List<Road> ids,Org4RoadVO orgVO) {
        orgVO.setRoadCount(ids.size());
        orgVO.setRoadLength(new BigDecimal(ids.stream().mapToDouble(Road::getLength).sum()));
        if ("4".equals(orgVO.getGrade())){
            orgVO.setRoadSegmentId(ids.get(0).getId());
        }
        return orgVO;
    }

    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            // 遍历出父id等于参数的id，add进子节点集合
            if (parentId.equals(org.getParentId())) {
                // 递归遍历下一级
                getOrgChild(orgList, org.getId(), rtnList);
                rtnList.add(org);
            }
        }
        return rtnList;
    }


    public static List<Org4RoadVO> getChild(List<Org4RoadVO> allList, String pCode) {
        List<Org4RoadVO> returnList = new ArrayList<>();
        for (Org4RoadVO entity : allList){
            if (pCode.equals(entity.getParentId())) {
                entity.setChirldren(getChild(allList, entity.getId()));
                returnList.add(entity);
            }
        }
        return returnList;
    }

    @Override
    public PageList<Road> queryRoad(QueryFilter<Road> queryFilter) {

        PageBean pageBean = new PageBean();
        pageBean.setPageSize(PageBean.DEFAULT_PAGE_SIZE);
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
//            queryFilter.addFilter("COMPANY_ID", String.join("','", baseContext.getCurrentOrgId()), QueryOP.IN, FieldRelation.AND);
            permissionUtils.addPermissionNo(queryFilter);
        }
        IPage<Road> result = baseMapper.getRoad(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<Road>(result);

    }

    @Override
    public void updateRoad(String id) {
        UpdateWrapper<Road> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq(StringUtils.isNotBlank(id), "id_", id);
        updateWrapper.set("is_dele_", "1");
        roadDao.update(null, updateWrapper);
    }
}
