package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 民工工资发放情况表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-13
 */
@ApiModel(value="BizMigrantWorkersSalary对象", description="民工工资发放情况表")
@TableName("biz_migrant_workers_salary")
public class BizMigrantWorkersSalary extends BizModel<BizMigrantWorkersSalary> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "业务主键id")
    @TableField("SALARY_ID_")
    private String salaryId;

    @ApiModelProperty(value = "工人表业务主键id")
    @TableField("WORKER_ID_")
    private String workerId;

    @ApiModelProperty(value = "工资月份")
    @TableField("MONTH_")
    private String month;

    @ApiModelProperty(value = "工作时长")
    @TableField("WORK_DURATION_")
    private String workDuration;

    @ApiModelProperty(value = "工资实际发放时间")
    @TableField("PAY_TIME_")
    private LocalDate payTime;

    @ApiModelProperty(value = "发放单位")
    @TableField("PAY_UNIT_")
    private String payUnit;

    @ApiModelProperty(value = "主要项目")
    @TableField("MAIN_PROJECT_ID_")
    private String mainProjectId;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "1-有效（默认值）、0-无效")
    @TableField("VALID_FLAG_")
    private Integer validFlag;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getSalaryId() {
        return salaryId;
    }

    public void setSalaryId(String salaryId) {
        this.salaryId = salaryId;
    }
    public String getWorkerId() {
        return workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }
    public String getMonth() {
        return month;
    }

    public void setMonth(String month) {
        this.month = month;
    }
    public String getWorkDuration() {
        return workDuration;
    }

    public void setWorkDuration(String workDuration) {
        this.workDuration = workDuration;
    }
    public LocalDate getPayTime() {
        return payTime;
    }

    public void setPayTime(LocalDate payTime) {
        this.payTime = payTime;
    }
    public String getPayUnit() {
        return payUnit;
    }

    public void setPayUnit(String payUnit) {
        this.payUnit = payUnit;
    }
    public String getMainProjectId() {
        return mainProjectId;
    }

    public void setMainProjectId(String mainProjectId) {
        this.mainProjectId = mainProjectId;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public Integer getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Integer validFlag) {
        this.validFlag = validFlag;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizMigrantWorkersSalary{" +
            "id=" + id +
            ", salaryId=" + salaryId +
            ", workerId=" + workerId +
            ", month=" + month +
            ", workDuration=" + workDuration +
            ", payTime=" + payTime +
            ", payUnit=" + payUnit +
            ", mainProjectId=" + mainProjectId +
            ", remarks=" + remarks +
            ", validFlag=" + validFlag +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
        "}";
    }
}
