package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.model.BizContractDetailChangeInvalid;
import com.artfess.yhxt.specialproject.dao.BizContractDetailChangeInvalidDao;
import com.artfess.yhxt.specialproject.manager.BizContractDetailChangeInvalidManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

/**
 * 合同明细变更待生效表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-16
 */
@Service
public class BizContractDetailChangeInvalidManagerImpl extends BaseManagerImpl<BizContractDetailChangeInvalidDao, BizContractDetailChangeInvalid> implements BizContractDetailChangeInvalidManager {

    @Override
    public PageList<BizContractDetailChangeInvalid> queryBizContractDetailChangeInvalid(QueryFilter<BizContractDetailChangeInvalid> queryFilter) {
        IPage<BizContractDetailChangeInvalid> result = baseMapper.queryBizContractDetailChangeInvalid(convert2IPage(queryFilter.getPageBean()),convert2Wrapper(queryFilter,currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizContractDetailChangeInvalid getBizContractDetailChangeInvalidById(String id) {
        BizContractDetailChangeInvalid bizContractDetailChangeInvalid = baseMapper.selectById(id);
        return bizContractDetailChangeInvalid;
    }
}
