package com.artfess.yhxt.specialproject.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.model.ProjectContractPayment;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.specialproject.vo.ProjectContractPaymentVo;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 项目合同支付表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-19
 */
public interface ProjectContractPaymentManager extends BaseManager<ProjectContractPayment> {

    /**
     * 分页查询合同支付接口
     * @param queryFilter
     * @return
     */
    PageList<ProjectContractPayment> queryProjectContractPayment(QueryFilter<ProjectContractPayment> queryFilter);

    /**
     * 保存支付信息
     * @param paymentList
     */
    void createProjectContractPayment(List<ProjectContractPayment> paymentList, String contractId);


    void importDatePay(MultipartFile file, String contractId);

    /**
     * 根据合同id 查询合同信息和合同支付明细
     * @param id 合同id
     * @return ProjectContractPaymentVo
     */
    ProjectContractPaymentVo getVo(String id);

    void downTemplate(HttpServletResponse response) throws IOException;

    void exportDatePay(String ids,HttpServletResponse response) throws Exception;
}
