package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialproject.model.BizContractDetailChangeInvalid;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialproject.model.BizContractDetailChangeInvalid;
import com.artfess.yhxt.specialproject.manager.BizContractDetailChangeInvalidManager;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * 合同明细变更待生效表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-16
 */
@RestController
@RequestMapping("/bizContractDetailChangeInvalid/v1/")
@Api(tags = "合同明细变更待生效")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizContractDetailChangeInvalidController extends BaseController<BizContractDetailChangeInvalidManager, BizContractDetailChangeInvalid> {

    @Resource
    private BaseContext baseContext;

    @Resource
    private PermissionUtils permissionUtils;

    @RequestMapping(value = "/saveContractDetailChangeInvalid",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改合同明细变更待生效信息",httpMethod = "POST")
    public CommonResult<String> saveEngineeringProject(@ApiParam(name = "bizContractDetailChangeInvalid",value = "合同明细变更待生效对象") @RequestBody BizContractDetailChangeInvalid bizContractDetailChangeInvalid) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(bizContractDetailChangeInvalid.getId())){
            bizContractDetailChangeInvalid.setIsDele("0");
            baseService.create(bizContractDetailChangeInvalid);
        }else {
            baseService.update(bizContractDetailChangeInvalid);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }


    @RequestMapping(value = "/getJson",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询合同明细变更待生效",httpMethod ="POST")
    public PageList<BizContractDetailChangeInvalid> getJson(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizContractDetailChangeInvalid> queryFilter){
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermissionByCreateOrgId(queryFilter);
        }
        PageList<BizContractDetailChangeInvalid> pageList = baseService.queryBizContractDetailChangeInvalid(queryFilter);
        return pageList;
    }

    @GetMapping(value = "get/{id}")
    @ApiOperation(value = "根据ID查询合同明细变更待生效信息",httpMethod = "GET",notes = "根据ID查询合同明细变更待生效")
    public BizContractDetailChangeInvalid get(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getBizContractDetailChangeInvalidById(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除合同明细变更待生效",httpMethod = "DELETE",notes = "批量删除合同明细变更待生效")
    public CommonResult<String> removes(@ApiParam(name = "ids",value = "对各主键用逗号分隔",required = true) @RequestParam String... ids) throws Exception{
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true,"删除成功");
    }

    @RequestMapping(value = "/updateContractDetailChangeInvalid",method = RequestMethod.DELETE,produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除合同明细变更待生效",httpMethod = "DELETE",notes = "逻辑删除合同明细变更待生效")
    public CommonResult<String> updateContractDetailChangeInvalid(@ApiParam(name = "ids",value = "ID集合以，隔开",required = true)
                                              @RequestParam(value = "ids",required = true)String ids)throws Exception{
        if (StringUtils.isNotBlank(ids)){
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizContractDetailChangeInvalid> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_",idsList);
            updateWrapper.set("is_dele_","1");
            baseService.update(null,updateWrapper);
        }
        return new CommonResult<>(true,"删除成功");
    }

}
