package com.artfess.yhxt.check.detail.model;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 隧道定期检查明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-17
 */
@ApiModel(value="TunnelRegularCheckDetail对象", description="隧道定期检查明细表")
@TableName("biz_tunnel_regular_check_detail")
public class TunnelRegularCheckDetail extends BaseModel<TunnelRegularCheckDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "隧道定期检查明细表")
    @TableField("TUNNEL_REGULAR_CHECK_ID_")
    private String tunnelRegularCheckId;

    @Excel(name = "结构名称", orderNum = "0")
    @ApiModelProperty(value = "结构名称")
    @TableField("UNIT_NAME_")
    private String unitName;

    @Excel(name = "里程桩号", orderNum = "1")
    @ApiModelProperty(value = "里程桩号")
    @TableField("MILEAGE_PILE_NUM_")
    private String mileagePileNum;

    @Excel(name = "缺损位置", orderNum = "2")
    @ApiModelProperty(value = "缺损位置")
    @TableField("DEFECT_LOCATION_")
    private String defectLocation;

    @Excel(name = "检查内容", orderNum = "3")
    @ApiModelProperty(value = "检查内容")
    @TableField("CHECK_CONTENT_")
    private String checkContent;

    @Excel(name = "状况描述", orderNum = "4")
    @ApiModelProperty(value = "状况描述")
    @TableField("DESCRIPTION_")
    private String description;

    @Excel(name = "标尺(0-4)", orderNum = "5")
    @ApiModelProperty(value = "标尺(0-4)")
    @TableField("SCALE_")
    private String scale;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getTunnelRegularCheckId() {
        return tunnelRegularCheckId;
    }

    public void setTunnelRegularCheckId(String tunnelRegularCheckId) {
        this.tunnelRegularCheckId = tunnelRegularCheckId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getMileagePileNum() {
        return mileagePileNum;
    }

    public void setMileagePileNum(String mileagePileNum) {
        this.mileagePileNum = mileagePileNum;
    }
    public String getDefectLocation() {
        return defectLocation;
    }

    public void setDefectLocation(String defectLocation) {
        this.defectLocation = defectLocation;
    }
    public String getCheckContent() {
        return checkContent;
    }

    public void setCheckContent(String checkContent) {
        this.checkContent = checkContent;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    public String getScale() {
        return scale;
    }

    public void setScale(String scale) {
        this.scale = scale;
    }

    @Override
    protected Serializable pkVal() {
        return null;
    }

    @Override
    public String toString() {
        return "TunnelRegularCheckDetail{" +
            "id=" + id +
            ", tunnelRegularCheckId=" + tunnelRegularCheckId +
            ", unitName=" + unitName +
            ", mileagePileNum=" + mileagePileNum +
            ", defectLocation=" + defectLocation +
            ", checkContent=" + checkContent +
            ", description=" + description +
            ", scale=" + scale +
        "}";
    }
}
