package com.artfess.yhxt.basedata.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.math.BigDecimal;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 隧道信息表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-07-28
 */
@ApiModel(value="BizTunnelInformation对象", description="隧道信息表")
@TableName("BIZ_TUNNEL_INFORMATION")
@Data
@JsonInclude
public class TunnelInformation extends BizModel<TunnelInformation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "所属公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "所属公司多个ID")
    @TableField("COMPANY_IDS_")
    private String companyIds;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "编号")
    @TableField("NUMBER_")
    private String number;

    @ApiModelProperty(value = "所在路段id")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "所在路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "管养单位ID")
    @TableField("OFFICE_ID_")
    private String officeId;


    @ApiModelProperty(value = "管养单位名称")
    @TableField("OFFICE_NAME_")
    private String officeName;

    @ApiModelProperty(value = "名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "类型 1:特长隧道 2:长隧道 3:中隧道 4:短隧道")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "中心桩号")
    @TableField("CENT_PEG_")
    private String centPeg;

    @ApiModelProperty(value = "方向 1:上行方向 2:下行方向 3:上下双向 4:匝道")
    @TableField("DIRECTION_")
    private String direction;

    @ApiModelProperty(value = "等级 1:一级隧道 2:二级隧道 3:三级隧道")
    @TableField("GRADE_")
    private String grade;

    @ApiModelProperty(value = "长度")
    @TableField("LENGTH_")
    private Float length;

    @ApiModelProperty(value = "宽度")
    @TableField("WIDTH_")
    private Float width;

    @ApiModelProperty(value = "高度")
    @TableField("HIGHT_")
    private Float hight;

    @ApiModelProperty(value = "人行道宽度")
    @TableField("PERSON_WIDTH_")
    private String personWidth;

    @ApiModelProperty(value = "入口 1:削竹式 2:端墙式 3:翼墙式 4:环框式 5:柱式 6:台阶式 7:拱圈式  8:组合路堑端墙明门洞 9:单压式端墙明门洞")
    @TableField("ENTRANCE_FORM_")
    private String entranceForm;

    @ApiModelProperty(value = "出口 1:削竹式 2:端墙式 3:翼墙式 4:环框式 5:柱式 6:台阶式 7:拱圈式  8:组合路堑端墙明门洞 9:单压式端墙明门洞")
    @TableField("EXIT_FORM_")
    private String exitForm;

    @ApiModelProperty(value = "断面形式 1:直墙式单心圆拱 2:直墙式双心圆拱 3:曲墙式三心圆拱 4:圆曲线 5:多心圆拱 " +
            "6:椭圆形7:直墙式坦顶双心圆拱8:其他9:曲墙式尖顶三心圆拱10:三心圆曲边墙11:曲边墙")
    @TableField("SURFACE_LAY_")
    private String surfaceLay;

    @ApiModelProperty(value = "衬砌材料 1:连续配筋混凝土 2:水泥混凝土 3: 钢筋混凝土")
    @TableField("ON_MATERIAL_")
    private String onMaterial;

    @ApiModelProperty(value = "洞身材料 1:连续配筋混凝土 2:水泥混凝土 3: 钢筋混凝土")
    @TableField("BODY_MATERIAL_")
    private String bodyMaterial;

    @ApiModelProperty(value = "设计单位")
    @TableField("DESIGN_UNIT_")
    private String designUnit;

    @ApiModelProperty(value = "监管单位")
    @TableField("WATCH_UNIT_")
    private String watchUnit;

    @ApiModelProperty(value = "施工单位")
    @TableField("CONSTRUCT_UNIT_")
    private String constructUnit;

    @ApiModelProperty(value = "安全通道统计")
    @TableField("SAFE_CHANNELS_COUNT_")
    private String safeChannelsCount;

    @ApiModelProperty(value = "完成日期")
    @TableField("FINISH_DAY_")
    private String finishDay;

    @ApiModelProperty(value = "设计图纸")
    @TableField("DESIGN_DRAWING_")
    private String designDrawing;

    @ApiModelProperty(value = "设计文件")
    @TableField("DESIGN_FILE_")
    private String designFile;

    @ApiModelProperty(value = "施工文件")
    @TableField("CONSTRUCTION_FILE_")
    private String constructionFile;

    @ApiModelProperty(value = "完成文件")
    @TableField("COMPLETE_FILE_")
    private String completeFile;

    @ApiModelProperty(value = "检查文件")
    @TableField("CHECK_FILE_")
    private String checkFile;

    @ApiModelProperty(value = "管理员文件")
    @TableField("ADMIN_FILE_")
    private String adminFile;

    @ApiModelProperty(value = "定期检查报告")
    @TableField("REGULAR_CHECK_REPORT_")
    private String regularCheckReport;

    @ApiModelProperty(value = "专项检查报告")
    @TableField("SPECIAL_CHECK_REPORT_")
    private String specialCheckReport;

    @ApiModelProperty(value = "文件编号")
    @TableField("FILE_NUM_")
    private String fileNum;

    @ApiModelProperty(value = "文件地址")
    @TableField("FILE_PLACE_")
    private String filePlace;

    @ApiModelProperty(value = "创建日期")
    @TableField("CREATE_DAY_")
    private String createDay;

    @ApiModelProperty(value = "起点桩号")
    @TableField("START_PEG_")
    private Float startPeg;

    @ApiModelProperty(value = "止点桩号")
    @TableField("END_PEG_")
    private Float endPeg;

    @ApiModelProperty(value = "x")
    @TableField("X_")
    private String x;

    @ApiModelProperty(value = "y")
    @TableField("Y_")
    private String y;

    @ApiModelProperty(value = "类型值")
    @TableField("TYPE_VALUE_")
    private String typeValue;

    @ApiModelProperty(value = "中心值")
    @TableField("CENT_PEG_K_")
    private String centPegK;

    @ApiModelProperty(value = "出口值")
    @TableField("EXIT_FORM_VALUE_")
    private String exitFormValue;

    @ApiModelProperty(value = "等级值")
    @TableField("GRADE_VALUE_")
    private String gradeValue;

    @ApiModelProperty(value = "方向值")
    @TableField("DIRECTION_VALUE_")
    private String directionValue;

    @ApiModelProperty(value = "身体材料值")
    @TableField("BODY_MATERIAL_VALUE_")
    private String bodyMaterialValue;

    @ApiModelProperty(value = "入口样子值")
    @TableField("ENTRANCE_FORM_VALUE_")
    private String entranceFormValue;

    @ApiModelProperty(value = "表面铺设值")
    @TableField("SURFACE_LAY_VALUE_")
    private String surfaceLayValue;

    @ApiModelProperty(value = "上层材料值")
    @TableField("ON_MATERIAL_VALUE_")
    private String onMaterialValue;
    @ApiModelProperty(value = "是否为水下下隧道 (0:是 1:否 )")
    @TableField("SUBMERGED_TUNNEL_")
    private String submergedTunnel;

    @ApiModelProperty(value = "经度")
    @TableField("LNG")
    private Double lng;
    @ApiModelProperty(value = "维度")
    @TableField("LAT")
    private Double lat;

    @ApiModelProperty(value = "排水类型，1:洞顶排水2:洞内路侧排水3:洞内路而横向排水4:洞内地下排水5:洞口及明洞防排水" +
            "6:洞口边墙盲沟排水7:明洞盲沟排水9:其它")
    @TableField("DRAINAGE_TYPE_")
    private String drainageType;

    @ApiModelProperty(value = "隧道形式，1:分离 2:连拱")
    @TableField("TUNNEL_SHAPE_")
    private String tunnelShape;

    @ApiModelProperty(value = "消防设施")
    @TableField("FIRE_FIGHTING_FACILITIES_")
    private String fireFightingFacilities;

    @ApiModelProperty(value = "安全通道数量")
    @TableField("SAFETY_CHANNELS_AMOUNT_")
    private Integer safetyChannelsAmount;

    @ApiModelProperty(value = "隧道通风，10:自然通风 11:机械通风 12:混合通风")
    @TableField("TUNNEL_VENTILATION_")
    private Integer tunnelVentilation;

    @ApiModelProperty(value = "隧道照明，10:无照明 11:全部照明 12:局部照明")
    @TableField("TUNNEL_LIGHTING_")
    private Integer tunnelLighting;

    @ApiModelProperty(value = "所属行政区")
    @TableField("ADMINISTRATIVE_REGION_")
    private String administrativeRegion;

    @ApiModelProperty(value = "地理位置")
    @TableField("GEOGRAPHIC_POSITION_")
    private String geographicPosition;

    @ApiModelProperty(value = "车道数")
    @TableField("VEHICLE_LANE_AMOUNT_")
    private String vehicleLaneAmount;

    @ApiModelProperty(value = "进洞方向")
    @TableField("TUNNEL_ENTRY_DIRECTION_")
    private String tunnelEntryDirection;

    @ApiModelProperty(value = "隧道洞别")
    @TableField("TUNNEL_TYPE_")
    private String tunnelType;

    //正面图:frontView  侧面图:lateralView 二维平面图:twoDimensionalPlan
    @ApiModelProperty(value = "正面图")
    @TableField(exist = false )
    private List<Accessory> accessoriesFrontView;
    @ApiModelProperty(value = "侧面图")
    @TableField(exist = false )
    private List<Accessory> accessoriesLateralView;
    @ApiModelProperty(value = "二维平面图")
    @TableField(exist = false )
    private List<Accessory> accessoriesTwoDimensionalView;

//    @ApiModelProperty(value = "路段")
//    @TableField(exist = false)
//    private Road road;
}
