package com.artfess.yhxt.thirdparty.vo;

import com.artfess.yhxt.basedata.model.BridgeInformation;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class TpBridgePageVo  {

    private String id;


    @ApiModelProperty(value = "桥梁名称")
    private String bridgeName;

    @ApiModelProperty(value = "桥梁编码")

    private String bridgeCode;


    @ApiModelProperty(value = "桥梁在养护系统中的id")
    private String bridgeId;

    @ApiModelProperty(value = "状态")

    private Integer state;

    @ApiModelProperty(value = "桥梁类型 1.悬索桥 2.斜拉桥 3.梁桥 4.拱桥")

    private Integer type;


    @ApiModelProperty(value = "公司ID")

    private String companyId;

    @ApiModelProperty(value = "所属公司多个ID")

    private String companyIds;

    @ApiModelProperty(value = "所属公司名称")

    private String companyName;


    @ApiModelProperty(value = "所在路段id(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "所在路段名称")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;



    @ApiModelProperty(value = "横坐标")
    @TableField("LNG")
    private Double lng;
    @ApiModelProperty(value = "纵坐标")
    @TableField("LAT")
    private Double lat;

}
