package com.artfess.yhxt.specialproject.model;

import java.math.BigDecimal;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 工程项目表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-10
 */
@ApiModel(value="BizEngineeringProject对象", description="工程项目表")
@TableName("biz_engineering_project")
@Data
public class BizEngineeringProject extends BizModel<BizEngineeringProject> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "项目id")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "父项目id")
    @TableField("PARENT_PROJECT_ID_")
    private String parentProjectId;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "工程属性")
    @TableField("PROJECT_NATURE_")
    private String projectNature;

    @ApiModelProperty(value = "路段id")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "所属路段名称")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "管理中心id")
    @TableField("MANAGE_UNIT_ID_")
    private String manageUnitId;

    @ApiModelProperty(value = "名称")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "类型")
    @TableField("PROJECT_TYPE_")
    private String projectType;

    @ApiModelProperty(value = "类型值")
    @TableField("PROJECT_TYPE_VALUE_")
    private String projectTypeValue;

    @ApiModelProperty(value = "项目金额")
    @TableField("PROJECT_MONEY_")
    private BigDecimal projectMoney;

    @ApiModelProperty(value = "项目年份")
    @TableField("PROJECT_YEAR_")
    private String projectYear;

    @ApiModelProperty(value = "项目总结")
    @TableField("PROJECT_SUMMARIZE_")
    private String projectSummarize;

    @ApiModelProperty(value = "维修原因")
    @TableField("REPAIR_REASON_")
    private String repairReason;

    @ApiModelProperty(value = "处置方法")
    @TableField("DISPOSAL_METHODS_")
    private String disposalMethods;

    @ApiModelProperty(value = "业主代表")
    @TableField("OWNER_REPRESENTATIVE_")
    private String ownerRepresentative;

    @ApiModelProperty(value = "施工单位")
    @TableField("CONSTRUCT_UNIT_")
    private String constructUnit;

    @ApiModelProperty(value = "施工单位负责人")
    @TableField("CONSTRUCT_UNIT_PERSON_LIABLE_")
    private String constructUnitPersonLiable;

    @ApiModelProperty(value = "设计单位")
    @TableField("DESIGN_UNIT_")
    private String designUnit;

    @ApiModelProperty(value = "设计单位id")
    @TableField("DESIGN_UNIT_ID_")
    private String designUnitId;

    @ApiModelProperty(value = "设计单位IDS")
    @TableField("DESIGN_UNIT_IDS_")
    private String designUnitIds;

    @ApiModelProperty(value = "监理单位")
    @TableField("SUPERVISOR_UNIT_")
    private String supervisorUnit;

    @ApiModelProperty(value = "监理单位id")
    @TableField("SUPERVISOR_UNIT_ID_")
    private String supervisorUnitId;

    @ApiModelProperty(value = "监理单位ids")
    @TableField("SUPERVISOR_UNIT_IDS_")
    private String supervisorUnitIds;

    @ApiModelProperty(value = "工作进度")
    @TableField("WORK_PROGRESS_")
    private String workProgress;

    @ApiModelProperty(value = "工作滞后原因")
    @TableField("WORK_LAG_REASON_")
    private String workLagReason;

    @ApiModelProperty(value = "是否检测")
    @TableField("IS_CHECK_")
    private String isCheck;

    @ApiModelProperty(value = "检测类型")
    @TableField("CHECK_TYPE_")
    private String checkType;

    @ApiModelProperty(value = "检测单位肯定情况")
    @TableField("CHECK_UNIT_CONFIRM_SITUATION_")
    private String checkUnitConfirmSituation;

    @ApiModelProperty(value = "检测进度")
    @TableField("CHECK_PROGRESS_")
    private String checkProgress;

    @ApiModelProperty(value = "是否设计")
    @TableField("IS_DESIGN_")
    private String isDesign;

    @ApiModelProperty(value = "设计单位确定情况")
    @TableField("DESIGN_UNIT_CONFIRM_SITUATION_")
    private String designUnitConfirmSituation;

    @ApiModelProperty(value = "设计进度")
    @TableField("DESIGN_PROGRESS_")
    private String designProgress;

    @ApiModelProperty(value = "是否招标")
    @TableField("IS_TENDERING_")
    private String isTendering;

    @ApiModelProperty(value = "上限价编制")
    @TableField("CAP_PRICE_")
    private String capPrice;

    @ApiModelProperty(value = "招标询价")
    @TableField("BIDDING_INQUIRY_")
    private String biddingInquiry;

    @ApiModelProperty(value = "合同签订")
    @TableField("CONTRACT_SIGNING_")
    private String contractSigning;

    @ApiModelProperty(value = "合同未签订原因")
    @TableField("CONTRACT_NOT_SIGNING_REASON_")
    private String contractNotSigningReason;

    @ApiModelProperty(value = "施工进度")
    @TableField("CONSTRUCTION_PROGRESS_")
    private String constructionProgress;

    @ApiModelProperty(value = "未施工原因")
    @TableField("NOT_CONSTRUCTION_REASON_")
    private String notConstructionReason;

    @ApiModelProperty(value = "是否交工")
    @TableField("IS_DELIVER_")
    private String isDeliver;

    @ApiModelProperty(value = "实际交工时间")
    @TableField("DELIVER_TIME_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private LocalDate deliverTime;

    @ApiModelProperty(value = "结算情况")
    @TableField("SETTLEMENT_INFO_")
    private String settlementInfo;

    @ApiModelProperty(value = "施工单位名称")
    @TableField("CONSTRUCT_UNIT_NAME_")
    private String constructUnitName;

    @ApiModelProperty(value = "施工单位名称id")
    @TableField("CONSTRUCT_UNIT_id_")
    private String constructUnitId;

    @ApiModelProperty(value = "施工单位名称ids")
    @TableField("CONSTRUCT_UNIT_IDS_")
    private String constructUnitIds;

    @ApiModelProperty(value = "1-已开工、0-未开工（默认值）")
    @TableField("STARTUP_FLAG_")
    private Integer startupFlag;

    @ApiModelProperty(value = "1-有效（默认值）、0-无效")
    @TableField("VALID_FLAG_")
    private Integer validFlag;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;


    @ApiModelProperty(value = "预算明细ID")
    @TableField("YEAR_BUDGET_DETAILED_ID_")
    private String yearBudgetDetailedId;


    @ApiModelProperty(value = "专项类型：0政策型专项；1非政策型专项")
    @TableField("SPECIAL_TYPE_")
    private String specialType;

    @TableField(exist = false)
    private BigDecimal persent;


//    @ApiModelProperty(value = "施工地点")
//    @Excel(name ="施工地点",width = 20)
//    private String constructLocation;
//
//
//    @ApiModelProperty(value = "项目发包")
//    @Excel(name ="项目发包",width = 20)
//    private String projectContractAwarding;
//    @ApiModelProperty(value = "项目负责人")
//    @Excel(name ="项目负责人",width = 20)
//    private String constructUnitPersonLiabl
//    @ApiModelProperty(value = "联系电话")
//    @Excel(name ="联系电话",width = 20)
//    private String constructUnitPersonTel;


}
