package com.artfess.yhxt.specialproject.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.model.BizProjectManageQuality;
import com.artfess.yhxt.specialproject.model.BizProjectManageQualityChange;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.specialproject.vo.BizProjectManageQualityChangeVo;
import com.artfess.yhxt.specialproject.vo.ProjectManageQualityChangeVo;

/**
 * 工程质量管理质检单整改表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-16
 */
public interface BizProjectManageQualityChangeManager extends BaseManager<BizProjectManageQualityChange> {

    PageList<BizProjectManageQualityChange> queryBizProjectManageQualityChange(QueryFilter<BizProjectManageQualityChange> queryFilter);

    BizProjectManageQualityChange getBizProjectManageQualityChangeById(String id);

    PageList<BizProjectManageQualityChangeVo> queryProjectManageQuality(QueryFilter<BizProjectManageQualityChange> queryFilter);

    /**
     * 保存工程质量管理质检单整改信息
     * @param projectManageQualityChangeVo
     */
    void saveVo(ProjectManageQualityChangeVo projectManageQualityChangeVo);

    /**
     * 修改工程质量管理质检单整改信息
     * @param projectManageQualityChangeVo
     */
    void updateVo(ProjectManageQualityChangeVo projectManageQualityChangeVo);

    /**
     * 根据id查询工程质量管理质检单整改信息详细信息
     * @param id
     * @return
     */
    ProjectManageQualityChangeVo getVo(String id);
}
