package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialproject.model.BizContractChangeInvalid;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialproject.model.BizContractChangeInvalid;
import com.artfess.yhxt.specialproject.manager.BizContractChangeInvalidManager;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * 合同信息变更待生效表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-12
 */
@RestController
@RequestMapping("/bizContractChangeInvalid/v1/")
@Api(tags = "合同信息变更待生效")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizContractChangeInvalidController extends BaseController<BizContractChangeInvalidManager, BizContractChangeInvalid> {

    @Resource
    private PermissionUtils permissionUtils;

    @Resource
    private BaseContext baseContext;

    @RequestMapping(value = "/saveContractChangeInvalid",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改合同信息变更待生效",httpMethod = "POST")
    public CommonResult<String> saveEngineeringProject(@ApiParam(name = "bizContractChangeInvalid",value = "合同信息变更待生效对象") @RequestBody BizContractChangeInvalid bizContractChangeInvalid) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(bizContractChangeInvalid.getId())){
            bizContractChangeInvalid.setIsDele("0");
            baseService.create(bizContractChangeInvalid);
        }else {
            baseService.update(bizContractChangeInvalid);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }


    @RequestMapping(value = "/getJson",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询合同信息变更待生效",httpMethod ="POST")
    public PageList<BizContractChangeInvalid> getJson(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizContractChangeInvalid> queryFilter){
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermissionByCreateOrgId(queryFilter);
        }
        PageList<BizContractChangeInvalid> pageList = baseService.queryBizContractChangeInvalid(queryFilter);
        return pageList;
    }

    @GetMapping(value = "get/{id}")
    @ApiOperation(value = "根据ID查询合同信息变更待生效信息",httpMethod = "GET",notes = "根据ID查询合同信息变更待生效")
    public BizContractChangeInvalid get(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getBizContractChangeInvalidById(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除合同信息变更待生效",httpMethod = "DELETE",notes = "批量删除合同信息变更待生效")
    public CommonResult<String> removes(@ApiParam(name = "ids",value = "对各主键用逗号分隔",required = true) @RequestParam String... ids) throws Exception{
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true,"删除成功");
    }

    @RequestMapping(value = "/updateContractChangeInvalid",method = RequestMethod.DELETE,produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除合同信息变更待生效",httpMethod = "DELETE",notes = "逻辑删除合同信息变更待生效")
    public CommonResult<String> updateContractChangeInvalid(@ApiParam(name = "ids",value = "ID集合以，隔开",required = true)
                                              @RequestParam(value = "ids",required = true)String ids)throws Exception{
        if (StringUtils.isNotBlank(ids)){
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizContractChangeInvalid> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_",idsList);
            updateWrapper.set("is_dele_","1");
            baseService.update(null,updateWrapper);
        }
        return new CommonResult<>(true,"删除成功");
    }
}
