package com.artfess.yhxt.specialcheck.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 巡检表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-12
 */
@ApiModel(value="SiteInspection对象", description="巡检表")
@TableName("BIZ_SITE_INSPECTION")
@Data
public class SiteInspection extends BizModel<SiteInspection> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "所属管理中心ID")
    @TableField("MANAGE_UNIT_ID_")
    private String manageUnitId;

    @ApiModelProperty(value = "所属管理中心NAME")
    @TableField("MANAGE_UNIT_NAME_")
    private String manageUnitName;

    @ApiModelProperty(value = "所属路段(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "所属路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "路线ID，选择路段时带入")
    @TableField("ROUTE_ID_")
    private String routeId;

    @ApiModelProperty(value = "路线名称，选择路段时带入")
    @TableField("ROUTE_NAME_")
    private String routeName;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;



    @ApiModelProperty(value = "巡检类型，使用数据字典 1：日巡检 2.夜巡检")
    @TableField("TYPE_")
    private Integer type;

    @ApiModelProperty(value = "所属公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "巡查日期")
    @TableField("PATROL_DATE_")
    private LocalDate patrolDate;

    @ApiModelProperty(value = "开始时间")
    @TableField("START_TIME_")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    @TableField("END_TIME_")
    private String endTime;

    @ApiModelProperty(value = "天气")
    @TableField("WEATHER_")
    private String weather;

    @ApiModelProperty(value = "天气值")
    @TableField("WEATHER_VALUE_")
    private String weatherValue;

    @ApiModelProperty(value = "状态，1：创建巡检任务，2：接受巡检任务，3：完成巡检任务 4：确认无病害 5：填写病害 6：拒绝巡检 7：转办")
    @TableField("HAND_STATUS_")
    private String handStatus;

    @ApiModelProperty(value = "巡检人ID")
    @TableField("RUMMAGER_ID_")
    private String rummagerId;

    @ApiModelProperty(value = "巡检人登录账户，用户发送消息")
    @TableField("RUMMAGER_ACCOUNT_")
    private String rummagerAccount;

    @ApiModelProperty(value = "记录人ID")
    @TableField("RECORDER_ID_")
    private String recorderId;

    @ApiModelProperty(value = "记录人登录账户")
    @TableField("RECORDER_ACCOUNT_")
    private String recorderAccount;

    @ApiModelProperty(value = "巡查情况及存在问题")
    @TableField("PROBLEM_")
    private String problem;

    @ApiModelProperty(value = "巡检内容")
    @TableField("CONTENT_")
    private String content;

    @ApiModelProperty(value = "巡检编号")
    @TableField("JOB_NUMBER_")
    private String jobNumber;
    @ApiModelProperty(value = "巡检人多个用逗号分割")
    @TableField("FULLNAME_")
    private String fullname;


}
