package com.artfess.yhxt.specialcheck.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.specialcheck.model.BizBridgeSpecialCheck;
import com.artfess.yhxt.specialcheck.model.BizTunnelSpecialCheck;
import com.artfess.yhxt.specialcheck.model.BizTunnelSpecialCheck;
import com.artfess.yhxt.specialcheck.dao.BizTunnelSpecialCheckDao;
import com.artfess.yhxt.specialcheck.manager.BizTunnelSpecialCheckManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialcheck.vo.BizTunnelSpecialCheckVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 隧道专项检查表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-10
 */
@Service
public class BizTunnelSpecialCheckManagerImpl extends BaseManagerImpl<BizTunnelSpecialCheckDao, BizTunnelSpecialCheck> implements BizTunnelSpecialCheckManager {
    @Resource
    PermissionUtils permissionUtils;
    @Resource
    private AccessoryManager accessoryManager;
    @Resource
    BaseContext baseContext;
    @Override
    public PageList<BizTunnelSpecialCheck> queryBizTunnelSpecialCheck(QueryFilter<BizTunnelSpecialCheck> queryFilter) {
        HashMap<String, Object> map = new HashMap<>();
        Map<String, Object> params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId())) {
//            queryFilter.addFilter("COMPANY_ID_", String.join("','", baseContext.getCurrentOrgId()), QueryOP.IN, FieldRelation.AND);
            permissionUtils.addPermission(queryFilter);
        }
        IPage<BizTunnelSpecialCheck> result = baseMapper.queryBizTunnelSpecialCheck(convert2IPage(queryFilter.getPageBean()), map, convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizTunnelSpecialCheck getBizBridgeSpecialById(String id) {
        BizTunnelSpecialCheck bizTunnelSpecialCheck = baseMapper.selectById(id);
        return bizTunnelSpecialCheck;
    }

    @Override
    public void saveVo(BizTunnelSpecialCheckVo bizTunnelSpecialCheckVo) {
        //隧道专项检查
        BizTunnelSpecialCheck bizTunnelSpecialCheck = bizTunnelSpecialCheckVo.getBizTunnelSpecialCheck();
        //保存桥梁专项检查信息
        this.create(bizTunnelSpecialCheck);

        //保存附件信息
        List<Accessory> accessoryList = bizTunnelSpecialCheckVo.getAccessories();
        //资源ID
        String id = bizTunnelSpecialCheck.getId();
        if (accessoryList.size() > 0) {
            //删除原来的附件信息
            // this.accessoryManager.delAccessoryBySourceId(id);
            //设置附件资源ID
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessoryList);
        }
    }

    @Override
    public void updateVo(BizTunnelSpecialCheckVo bizTunnelSpecialCheckVo) {
        BizTunnelSpecialCheck bizTunnelSpecialCheck = bizTunnelSpecialCheckVo.getBizTunnelSpecialCheck();
        //附件信息
        List<Accessory> accessoryList = bizTunnelSpecialCheckVo.getAccessories();
        //修改桥梁专项检查
        this.update(bizTunnelSpecialCheck);
        //资源ID
        String id = bizTunnelSpecialCheck.getId();
        if (accessoryList.size()>0) {
            //删除原来的附件信息
            this.accessoryManager.delAccessoryBySourceId(id);
            //获取附件信息
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessoryList);
        }
    }

    @Override
    public BizTunnelSpecialCheckVo getVo(String id) {
        BizTunnelSpecialCheckVo bizTunnelSpecialCheckVo = new BizTunnelSpecialCheckVo();
        //获取隧道专项检查
        BizTunnelSpecialCheck bizTunnelSpecialCheck = this.baseMapper.selectById(id);
        //获取附件信息
        List<Accessory> accessoryList = this.accessoryManager.getAccessoryBySourceId(id);
        bizTunnelSpecialCheckVo.setBizTunnelSpecialCheck(bizTunnelSpecialCheck);
        bizTunnelSpecialCheckVo.setAccessories(accessoryList);
        return bizTunnelSpecialCheckVo;
    }
}
