package com.artfess.yhxt.contract.controller;


import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.*;
import com.artfess.base.util.time.DateUtil;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.uc.model.User;
import com.artfess.workflow.runtime.manager.IFlowManager;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.budget.model.YearBudget;
import com.artfess.yhxt.contract.model.BillOfQuantities;
import com.artfess.yhxt.contract.vo.*;
import com.artfess.yhxt.disease.vo.DiseaseReportVO;
import com.artfess.yhxt.specialproject.model.BizEngineeringProject;
import com.artfess.yhxt.statistics.vo.OrgVO;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.contract.model.WorkOrderInformation;
import com.artfess.yhxt.contract.manager.WorkOrderInformationManager;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 工单信息表 前端控制器
 *
 * @author wangping
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-20
 */
@RestController
@RequestMapping("/workOrderInformation/v1/")
@Api(tags = "工单信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class WorkOrderInformationController extends BaseController<WorkOrderInformationManager, WorkOrderInformation> {
    @Resource
    BaseContext baseContext;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    IFlowManager iFlowService;
    @Resource
    private SysIdentityManager sysIdentityManager;

    @RequestMapping(value = "monthReport", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取工单月报报表", httpMethod = "GET", notes = "获取工单月报报表")
    public List<OrderMonthVO> monthReport(String year, String orgId) throws Exception {
        return baseService.getMonthReport(year, orgId);
    }

    @RequestMapping(value = "orderReport", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取工单报表", httpMethod = "GET", notes = "获取工单报表")
    public List<OrderReportVO> orderReport(String year, String orgId) throws Exception {
        return baseService.getReport(year,orgId);
    }

    @RequestMapping(value = "workReport", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "日常养护施工完成情况统计", httpMethod = "GET", notes = "日常养护施工完成情况统计")
    public List<OrderWorkFinishVO> workReport(String year, String orgId) throws Exception {
        return baseService.getWorkFinishReport(year,orgId);
    }

    @RequestMapping(value = "orderMoneyReport", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取工单计量支付报表", httpMethod = "GET", notes = "获取工单计量支付报表")
    public List<OrderMoneyVO> orderMoneyReport(String year, String orgId) throws Exception {
        return baseService.getMoneyReport(year,orgId);
    }

    @RequestMapping(value = "orderCheckReport", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取工单验收报表", httpMethod = "GET", notes = "获取工单验收报表")
    public List<OrderCheckVO> orderCheckReport(String year, String orgId) throws Exception {
        return baseService.getCheckReport(year,orgId);
    }


    @RequestMapping(value = "orderItemCountReport", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取工单科目统计报表", httpMethod = "POST", notes = "获取工单科目统计报表")
    public PageList<OrderItemCountVo> orderItemCountReport(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<WorkOrderInformation> queryFilter) throws Exception {
        return baseService.orderItemCountReport(queryFilter);
    }

    @RequestMapping(value = "orderItemCountReportExport", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取工单科目统计报表导出", httpMethod = "POST", notes = "获取工单科目统计报表导出")
    public void orderItemCountReportExport(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<WorkOrderInformation> queryFilter, HttpServletResponse response)throws Exception {
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE);
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);

         baseService.orderItemCountReportExport(queryFilter,response);

    }


    @RequestMapping(value = "orderCashReport", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "养护资金执行情况", httpMethod = "POST", notes = "养护资金执行情况")
    public PageList<OrderCashVo> orderCashReport(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<YearBudget> queryFilter) throws Exception {
        return baseService.getOrderCashReport(queryFilter);
    }



    @PostMapping(value = "export/orderCashReport",  produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "养护资金执行情况-导出", httpMethod = "POST", notes = "养护资金执行情况")
    public void exportOrderCashReport(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<YearBudget> queryFilter,
                                         HttpServletResponse response) throws Exception {
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE);
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        baseService.exportOrderCashReport(queryFilter,response);
    }


    /**
     * 重大养护专项情况统计表 暂不处理
     * @param queryFilter
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "orderSpecialCashReport", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "重大养护专项情况统计表", httpMethod = "POST", notes = "重大养护专项情况统计表")
    public PageList<OrderSpecialCashVo> orderSpecialCashReport(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizEngineeringProject> queryFilter) throws Exception {
        return baseService.getOrderSpecialCashReport(queryFilter);
    }




    @RequestMapping(value = "export/orderSpecialCashReport", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "重大养护专项情况统计表-导出", httpMethod = "POST", notes = "重大养护专项情况统计表")
    public void exportOrderSpecialCashReport(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizEngineeringProject> queryFilter,
                                         HttpServletResponse response) throws Exception {
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE);
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        baseService.exportOrderSpecialCashReport(queryFilter,response);
    }





    @RequestMapping(value = "/saveworkOrderInformation", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改工单信息", httpMethod = "POST")
    public CommonResult<String> saveWorkOrderInformation(@ApiParam(name = "workOrderInformation", value = "项目开工申请专项检查对象") @RequestBody WorkOrderInformation workOrderInformation) throws Exception {
        String msg = "添加成功";

        if (workOrderInformation.getEndTime() == null){
            LocalDate demandFinishTime = workOrderInformation.getDemandFinishTime();
            if(demandFinishTime.isBefore(LocalDate.now())){
                workOrderInformation.setOverdue(1);
            }else{
                workOrderInformation.setOverdue(0);
            }
        }
        if (StringUtils.isEmpty(workOrderInformation.getId())) {
            workOrderInformation.setIsDele("0");
            baseService.create(workOrderInformation);
        } else {
            baseService.update(workOrderInformation);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }


    @RequestMapping(value = "getJson", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "分页查询工单信息", httpMethod = "POST")
    public PageList<WorkOrderInformation> getJson(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<WorkOrderInformation> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageList<WorkOrderInformation> pageList = baseService.queryWorkOrderInformation(queryFilter);
        return pageList;
    }

    @GetMapping(value = "get/{id}")
    @ApiOperation(value = "根据ID查询工单信息", httpMethod = "GET", notes = "根据ID查询工单信息")
    public WorkOrderInformation get(@ApiParam(name = "id", value = "业务对象主键", required = true) @PathVariable String id) throws Exception {
        System.out.println(sysIdentityManager.nextId("yhgd"));
        return baseService.getWorkOrderInformationById(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除工单信息", httpMethod = "DELETE", notes = "批量删除工单信息")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "对各主键用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true, "删除成功");
    }

    @RequestMapping(value = "/updateWorkOrderInformation", method = RequestMethod.DELETE, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除工单信息", httpMethod = "DELETE", notes = "逻辑删除工单信息")
    public CommonResult<String> updateBeginApplyFor(@ApiParam(name = "ids", value = "ID集合以，隔开", required = true)
                                                    @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<WorkOrderInformation> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }

    @RequestMapping(value = "/saveVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改工单信息VO", httpMethod = "POST")
    public CommonResult<WorkOrderInformationVo> saveVo(@ApiParam(name = "vo", value = "工单信息Vo") @RequestBody WorkOrderInformationVo vo) throws Exception {
        //合同内清单排重
        List<BillOfQuantities> billOfQuantities = vo.getBillOfQuantities();

        if(null !=  billOfQuantities &&  billOfQuantities.size() > 0){
            billOfQuantities = billOfQuantities.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getContractItemId()))), ArrayList::new));
            vo.setBillOfQuantities(billOfQuantities);
        }



        String msg = "添加成功";
        if (StringUtils.isEmpty(vo.getWorkOrderInformation().getId())) {
            this.baseService.saveVo(vo);
        } else {
            msg = "修改成功";
            this.baseService.updateVo(vo);
        }
        return new CommonResult<WorkOrderInformationVo>(true, msg, vo);
    }

    @GetMapping(value = "getVo/{id}")
    @ApiOperation(value = "根据ID查询工单信息vo", httpMethod = "GET", notes = "根据ID查询工单信息vo")
    public WorkOrderInformationVo getVo(@ApiParam(name = "id", value = "业务对象主键", required = true) @PathVariable String id) throws Exception {
        WorkOrderInformationVo vo = baseService.getVo(id);
        return vo;
    }

    @RequestMapping(value = "getWorkOrderVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取所有的养护工单状态", httpMethod = "POST", notes = "获取所有的养护工单状态")
    public PageList<WorkOrderVo> getWorkOrderVo(@ApiParam(required = true, name = "queryFilter", value = "查询参数对象") @RequestBody QueryFilter queryFilter) throws Exception {

        return baseService.getWorkOrderVo(queryFilter);
    }

    @RequestMapping(value = "approve", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "最终审核", httpMethod = "POST", notes = "获取所有的养护工单状态")
    public  CommonResult<String> approve(@ApiParam(name = "id", value = "工单id", required = true) @RequestParam(value = "id", required = true) String id,
    @ApiParam(name = "state", value = "是否通过 0驳回 1通过", required = true) @RequestParam(value = "state", required = true) Integer state){

         baseService.approve(id,state);
         return new CommonResult<>(true,"操作完成" );
    }


    @RequestMapping(value = "getWorkCountVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取所有的养护工单数量", httpMethod = "POST", notes = "获取所有的养护工单状态")
    public List<OrgVO> getWorkCountVo(String startDate,String endDate) throws Exception {

        return baseService.getWorkOrderCount(startDate,endDate);
    }

    @RequestMapping(value = "getWorkOrder", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "根据开始、结束时间", httpMethod = "POST", notes = "根据开始、结束时间")
    public PageList<WorkOrderDiseaseVo> getWorkOrder(@ApiParam(required = true, name = "queryFilter", value = "查询参数对象（startTime开始时间 endTime 结束时间 roadId 路段id）") @RequestBody QueryFilter queryFilter) throws Exception {
        return baseService.getWorkOrder(queryFilter);
    }


    @RequestMapping(value = "getDoneInstList", method = RequestMethod.POST, produces = {
            "application/json; charset=utf-8"})
    @ApiOperation(value = "获取用户经办的流程实例", httpMethod = "POST", notes = "获取用户的已办事宜，参数status表示流程状态，不填表示查询所有")
    public PageList<Map<String, Object>> getWorkOrderEnd(@ApiParam(required = true, name = "queryFilter", value = "查询参数对象") @RequestBody QueryFilter queryFilter,
                                                         @ApiParam(name = "status", value = "流程状态", allowableValues = "running,end,manualend,cancel,back,revoke,revokeToStart", required = false) @RequestParam(required = false) String status,
                                                         HttpServletResponse response) throws Exception {

        return baseService.getDoneInstList(baseContext.getCurrentUserAccout(), queryFilter, status).get();
    }

    @RequestMapping(value = "getTodoList", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取用户的待办事宜", httpMethod = "POST", notes = "获取用户的待办事宜")
    public PageList<Map<String, Object>> getTodoList(@ApiParam(required = true, name = "queryFilter", value = "查询参数对象") @RequestBody QueryFilter<DefaultBpmTask> queryFilter) throws Exception {
        if (com.artfess.base.util.BeanUtils.isNotEmpty(queryFilter.getQuerys()) && queryFilter.getQuerys().size() > 0) {
            List<QueryField> fields = new ArrayList<>();
            for (Iterator<QueryField> iterator = queryFilter.getQuerys().iterator(); iterator.hasNext(); ) {
                QueryField field = (QueryField) iterator.next();
                if ("urgentStateValue".equals(field.getProperty())) {
                    field.setGroup("groupUrgent");
                    field.setRelation(FieldRelation.AND);
                    QueryFilter<DefaultBpmDefinition> defFilter = QueryFilter.<DefaultBpmDefinition>build();
                    defFilter.addFilter("IS_MAIN_", "Y", QueryOP.EQUAL);
                    defFilter.addFilter("SHOW_URGENT_STATE_", "1", QueryOP.EQUAL);
                    PageList<DefaultBpmDefinition> query = bpmDefinitionManager.query(defFilter);
                    List<String> defKeys = new ArrayList<>();
                    defKeys.add("-1");
                    if (com.artfess.base.util.BeanUtils.isNotEmpty(query.getRows())) {
                        for (DefaultBpmDefinition def : query.getRows()) {
                            defKeys.add(def.getDefKey());
                        }
                    }
                    fields.add(new QueryField("PROC_DEF_KEY_", defKeys, QueryOP.IN, FieldRelation.AND, "groupUrgent"));
                } else {
                    fields.add(field);
                }
            }
            queryFilter.setQuerys(fields);
        }

        queryFilter.setGroupRelation(FieldRelation.AND);
        PageList<DefaultBpmTask> pageList = iFlowService.getTodoList(baseContext.getCurrentUserAccout(), queryFilter).get();

        List<DefaultBpmTask> rows = pageList.getRows();
        PageList<Map<String, Object>> mapPageList = new PageList<>();
        List<Map<String, Object>> mapPageListRows = mapPageList.getRows();

        if (null==mapPageListRows){
            mapPageListRows=new ArrayList<Map<String, Object>>();
        }
        for (DefaultBpmTask row : rows) {
            //获取bizKEY
            String bizKey = baseService.getBizkey(row.getBpmnInstId());
            if (StringUtils.isEmpty(bizKey)) continue;
            WorkOrderInformation workOrderInformation = this.baseService.getById(bizKey);
            //查询路段
            if(null != workOrderInformation){
                Road road = baseService.getRoad(workOrderInformation.getRoadSegmentId());
                Map<String, Object> map = BeanUtil.beanToMap(row);
                workOrderInformation.setRoad(road);
                map.put("workOrderInformation",workOrderInformation);
                mapPageListRows.add( map);
            }
        }
        mapPageList.setPageSize(pageList.getPageSize());
        mapPageList.setPage(pageList.getPage());
        mapPageList.setTotal(pageList.getTotal());
        mapPageList.setRows(mapPageListRows);
        return mapPageList;
    }

    @RequestMapping(value = "getWorkOrderVoByBridge", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "桥梁档案-养护工单", httpMethod = "POST", notes = "桥梁档案-养护工单")
    public PageList<WorkOrderVo> getWorkOrderVoByBridge(
            @ApiParam(required = true, name = "workOrderByBridgeVo", value = "查询参数对象")
            @RequestBody WorkOrderAndBaseIdVo workOrderByBridgeVo) throws Exception {
        return baseService.getWorkOrderVoByBridge(workOrderByBridgeVo);
    }

    @RequestMapping(value = "getWorkOrderVoByTunnel", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "隧道档案-养护工单", httpMethod = "POST", notes = "根据隧道ID查询养护工单列表")
    public PageList<WorkOrderVo> getWorkOrderVoByTunnel(
            @ApiParam(required = true, name = "workOrderByBridgeVo", value = "查询参数对象")
            @RequestBody WorkOrderAndBaseIdVo workOrderByBridgeVo) throws Exception {
        return baseService.getWorkOrderVoByTunnel(workOrderByBridgeVo);
    }

    @RequestMapping(value = "getWorkOrderVoByCulvert", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "涵洞档案-养护工单", httpMethod = "POST", notes = "根据涵洞ID查询养护工单列表")
    public PageList<WorkOrderVo> getWorkOrderVoByCulvert(
            @ApiParam(required = true, name = "workOrderByBridgeVo", value = "查询参数对象")
            @RequestBody WorkOrderAndBaseIdVo workOrderByBridgeVo) throws Exception {
        return baseService.getWorkOrderVoByCulvert(workOrderByBridgeVo);
    }

    @RequestMapping(value = "getWorkOrderVoBySideSlope", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "边坡档案-养护工单", httpMethod = "POST", notes = "根据边坡ID查询养护工单列表")
    public PageList<WorkOrderVo> getWorkOrderVoBySideSlope(
            @ApiParam(required = true, name = "workOrderByBridgeVo", value = "查询参数对象")
            @RequestBody WorkOrderAndBaseIdVo workOrderByBridgeVo) throws Exception {
        return baseService.getWorkOrderVoBySideSlope(workOrderByBridgeVo);
    }
    @RequestMapping(value = "exportWorkOrder", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "单个工单导出", httpMethod = "GET", notes = "单个工单导出")
    public void exportWorkOrder(@ApiParam(name = "ids", value = "工单id用逗号分割", required = true) @RequestParam String ids, HttpServletResponse response) throws Exception {
        baseService.exportWorkOrder(ids, response);
    }




    @RequestMapping(value = "exportWorkOrders", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "按照时间导出工单", httpMethod = "GET", notes = "按照时间导出工单")
    public void exportWorkOrders(@ApiParam(name = "startTime", value = "开始时间yyyy-MM-dd", required = true) @RequestParam String startTime ,
                                 @ApiParam(name = "endTime", value = "结束时间yyyy-MM-dd", required = true) @RequestParam String endTime,
                                 @ApiParam(name = "contractId", value = "养护合同ID", required = true) @RequestParam String contractId,
                                 //@ApiParam(name = "type", value = "上传类型,按照类型  1：月 2：季度", required = false) @RequestParam String type,
                                 HttpServletResponse response) throws Exception {
       String  type = "2";
        baseService.exportWorkOrders(startTime,endTime,contractId, type, response);
    }


    /**
     *
     * @param startTime
     * @param endTime
     * @param contractId
     * @param response
     * @throws Exception
     */
    @RequestMapping(value = "exportWorkOrdersConstruction", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "按照时间导出工单 -已办工单导出", httpMethod = "GET", notes = "按照时间导出工单")
    public void exportWorkOrdersConstruction(@ApiParam(name = "startTime", value = "开始时间yyyy-MM-dd", required = true) @RequestParam String startTime ,
                                 @ApiParam(name = "endTime", value = "结束时间yyyy-MM-dd", required = true) @RequestParam String endTime,
                                 @ApiParam(name = "contractId", value = "养护合同ID", required = true) @RequestParam String contractId,
                                 //@ApiParam(name = "type", value = "上传类型,按照类型  1：月 2：季度", required = false) @RequestParam String type,
                                 HttpServletResponse response) throws Exception {
       String  type = "2";
        baseService.exportWorkOrdersConstruction(startTime,endTime,contractId, type, response);
    }










    @RequestMapping(value = "getPrincipal", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取承包方负责人信息", httpMethod = "GET", notes = "获取承包方负责人信息")
    public  List<User> getPrincipal(@ApiParam(required = true, name = "userId", value = "承包方经办人ID") String userId) throws Exception {
        return baseService.getPrincipal(userId);
    }

    @RequestMapping(value = "/deleWorkOrderInformation", method = RequestMethod.DELETE, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "删除工单信息", httpMethod = "DELETE", notes = "删除工单信息")
    public CommonResult<String> deleWorkOrderInformation(@ApiParam(name = "ids", value = "ID集合以，隔开", required = true)
                                                    @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            boolean result = this.baseService.deleWorkOrderInformation(ids);
            if (!result){
                return new CommonResult<>(false, "该工单不允许删除");
            }
        }
        return new CommonResult<>(true, "删除工单成功");
    }
}
