package com.artfess.yhxt.check.regular.controller;


import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.FileUtil;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.check.regular.manager.BridgeRegularCheckManager;
import com.artfess.yhxt.check.regular.model.BridgeRegularCheck;
import com.artfess.yhxt.check.regular.vo.BridgeRegularCheckFjVo;
import com.artfess.yhxt.check.regular.vo.BridgeRegularCheckVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 * 桥梁定期检查表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-16
 */
@RestController
@RequestMapping("/bridgeRegularCheck/v1/")
@Api(tags = "桥梁定期检查接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BridgeRegularCheckController extends BaseController<BridgeRegularCheckManager, BridgeRegularCheck> {
    @RequestMapping(value="getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询桥梁定期检查",httpMethod = "POST")
    public PageList<BridgeRegularCheck> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BridgeRegularCheck> queryFilter) {
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        PageList<BridgeRegularCheck> pageList = baseService.queryBridgeRegularCheck(queryFilter);
        return  pageList;
    }

    @RequestMapping(value = "saveBridgeRegularCheck", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存桥梁定期检查信息", httpMethod = "POST")
    public CommonResult<String> saveBridgeRegularCheck(@ApiParam(name = "vo", value = "定期检查vo") @RequestBody BridgeRegularCheckFjVo vo) throws Exception {
        String msg = "添加成功";
        this.baseService.saveBridgeRegularFjCheck(vo);
        return new CommonResult<String>(msg);
    }



    /**
     * 批量导入Excel数据
     *
     * @param file Excel文件
     */
    @PostMapping("/importExcelData")
    @ApiOperation(value = "Excel批量导入桥梁定期检查详情数据")
    public CommonResult importExcelData(
            @ApiParam("上传文件") @RequestParam("file") MultipartFile file,
            @ApiParam(name = "mainJson", value = "主数据JSON字符数据") @RequestParam("mainJson") String mainJson) {
        baseService.importExcelData(file, JSON.parseObject(mainJson, BridgeRegularCheck.class));
        return new CommonResult<>("导入成功");
    }

    /**
     * 下载导入模板
     *
     * @param response
     * @return
     */
    @ApiOperation(value = "下载导入模板")
    @GetMapping("/downModel")
    public void downTemplate(HttpServletResponse response) throws Exception {
        ClassPathResource classPathResource = new ClassPathResource("model/bridgeRegularCheckDetail.xlsx");
        FileUtil.fileDownload(response, classPathResource.getInputStream(), "桥梁定期检查导入模板.xlsx");
    }


    @RequestMapping(value = "updateBridgeRegularCheck", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改桥梁定期检查信息", httpMethod = "POST")
    public CommonResult<String> updateBridgeRegularCheck(@ApiParam(name = "vo", value = "定期检查vo") @RequestBody BridgeRegularCheckFjVo vo) throws Exception {
        String msg = "修改成功";
        this.baseService.updateBridgeRegularCheck(vo);
        return new CommonResult<String>(msg);
    }

    @RequestMapping(value="get/{id}",method = RequestMethod.GET, produces={"application/json; charset=utf-8" })
    @ApiOperation(value="根据ID查询桥梁定期检查信息",httpMethod = "GET",notes = "根据ID查询桥梁定期检查信息")
    public BridgeRegularCheckVo get(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
        return baseService.getBridgeRegularCheckById(id);
    }

    @RequestMapping(value = "deleteBridgeRegularCheck", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除桥梁定期检查信息", httpMethod = "POST", notes = "逻辑删除桥梁定期检查信息")
    public CommonResult<String> deleteBridgeRegularCheck(@ApiParam(name = "ids", value = "可视化分类ID集合以，隔开", required = true)
                                                       @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BridgeRegularCheck> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }





    @PostMapping("/minioRegularCheckUpload")
    @ApiOperation(value = "定期检查附件上传接口")
    public Accessory minioDiseaseUpload(MultipartFile file, @ApiParam(name = "sourceId",value = "资源id",required = true) String sourceId){
        Accessory accessory = this.baseService.minioRegularCheckUpload(file, sourceId);
        return accessory;
    }


    @DeleteMapping(value = "/removesRegularCheck")
    @ApiOperation(value = "删除定期检查附件", httpMethod = "DELETE", notes = "删除定期检查附件")
    public CommonResult<String> minioRegularCheck(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String ids) throws Exception {
        baseService.minioRegularCheck(Arrays.asList(ids.split(",")));
        return new CommonResult<String>(true, "删除成功");
    }

    @RequestMapping("/downloadRegularCheckUpload")
    @ApiOperation(value = "定期检查附件下载接口", httpMethod = "POST", notes = "定期检查附件下载接口")
    public void downloadRegularCheckUpload( @ApiParam(name = "ids", value = "附件ID集合以，隔开")
                                        @RequestParam(value = "ids", required = true) String ids,
                                        HttpServletResponse response) throws Exception {
        this.baseService.downloadRegularCheckUpload(ids,response);

    }
}
