package com.artfess.yhxt.basedata.vo;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 路段视频设备区域表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2022-08-30
 */
@ApiModel(value="BizRoadIndexCode对象", description="路段视频设备区域表")
@Data
public class BizRoadIndexCodeVO extends BaseModel<BizRoadIndexCodeVO> {


    @ApiModelProperty(value = "监控点编号")
    private String cameraIndexCode;

    @ApiModelProperty(value = "监控点国标编号")
    private String gbIndexCode;

    @ApiModelProperty(value = "所属设备编号")
    private String deviceIndexCode;

    @ApiModelProperty(value = "路段设备表id")
    private String roadIndexCodeId;

    @ApiModelProperty(value = "精度")
    private String longitude;

    @ApiModelProperty(value = "维度")
    private String latitude;

    @ApiModelProperty(value = "在线状态（0-不在线，1-在线")
    private String status;

    @ApiModelProperty(value = "传输协议（0-UDP，1-TCP")
    private String transType;


    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "区域编码")
    @TableField("INDEX_CODE_")
    private String indexCode;

    @ApiModelProperty(value = "区域名")
    @TableField("NAME")
    private String name;

    @ApiModelProperty(value = "路段id")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "创建人组织ID")
    @TableField("CREATE_ORG_ID_")
    private String createOrgId;

    @ApiModelProperty(value = "创建人组织名称")
    @TableField("CREATE_ORG_NAME_")
    private String createOrgName;

    @ApiModelProperty(value = "创建人单位ID")
    @TableField("CREATE_COMPANY_ID_")
    private String createCompanyId;

    @ApiModelProperty(value = "创建人单位名称")
    @TableField("CREATE_COMPANY_NAME_")
    private String createCompanyName;

    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人ID")
    @TableField("UPDATE_BY_")
    private String updateBy;

    @ApiModelProperty(value = "更新人姓名")
    @TableField("UPDATE_NAME_")
    private String updateName;

    @ApiModelProperty(value = "更新人单位名称")
    @TableField("UPDATE_COMPANY_NAME_")
    private String updateCompanyName;

    @ApiModelProperty(value = "更新人单位ID")
    @TableField("UPDATE_COMPANY_ID_")
    private String updateCompanyId;

    @ApiModelProperty(value = "更新人组织ID")
    @TableField("UPDATE_ORG_ID_")
    private String updateOrgId;

    @ApiModelProperty(value = "更新人组织名称")
    @TableField("UPDATE_ORG_NAME_")
    private String updateOrgName;

    @ApiModelProperty(value = "更新时间")
    @TableField("UPDATE_TIME_")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_")
    private Long lastTime;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    private Integer allCount;

    private Integer onlineCount;

    private List<BizRoadIndexCodeVO> list;


}
