package com.artfess.yhxt.basedata.vo;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 车辆设备表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2022-08-30
 */
@ApiModel(value="车辆视频设备VO", description="车辆视频设备VO")
@Data
public class BizCarEquipmentVO extends BaseModel<BizCarEquipmentVO> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "监控点编号")
    private String cameraIndexCode;

    @ApiModelProperty(value = "监控点国标编号")
    private String gbIndexCode;

    @ApiModelProperty(value = "所属设备编号")
    private String deviceIndexCode;

    @ApiModelProperty(value = "路段设备表id")
    private String roadIndexCodeId;

    @ApiModelProperty(value = "精度")
    private String longitude;

    @ApiModelProperty(value = "维度")
    private String latitude;

    @ApiModelProperty(value = "在线状态（0-不在线，1-在线")
    private String status;

    @ApiModelProperty(value = "传输协议（0-UDP，1-TCP")
    private String transType;

    @ApiModelProperty(value = "设备名称")
    private String name;

}
