package com.artfess.yhxt.basedata.dao;


import com.artfess.yhxt.basedata.model.TunnelInformation;
import com.artfess.base.query.PageList;
import com.artfess.yhxt.basedata.vo.TunnelCheckVo;
import com.artfess.yhxt.basedata.vo.TunnelRegularVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.Map;

/**
 * 隧道信息表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-07-28
 */
public interface TunnelInformationDao extends BaseMapper<TunnelInformation> {

    /**
     * 查询桥梁信息
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<TunnelCheckVo> queryTunnel(IPage<TunnelInformation> convert2IPage,
                                     @Param("map") Map<String, Object> params,
                                     @Param(Constants.WRAPPER) Wrapper<TunnelInformation> convert2Wrapper);

    IPage<TunnelInformation> queryTunnelInformation(IPage<TunnelInformation> convert2IPage,  @Param("map") Map<String, Object> params,@Param(Constants.WRAPPER) Wrapper<TunnelInformation> convert2Wrapper);

    IPage<TunnelRegularVo> queryTunnelRegularCheckVo(IPage<TunnelInformation> convert2IPage,
                                                     @Param("map") Map<String, Object> params,
                                                     @Param(Constants.WRAPPER) Wrapper<TunnelInformation> convert2Wrapper);
}
