package com.artfess.yhxt.basedata.controller;


import com.artfess.base.annotation.DataAccess;
import com.artfess.yhxt.basedata.manager.BridgeInformationManager;
import com.artfess.yhxt.basedata.model.BridgeInformation;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.basedata.vo.BridgeCheckVo;
import com.artfess.yhxt.basedata.vo.BridgeRegularVo;
import com.artfess.yhxt.statistics.vo.Org4BridgeVO;
import com.artfess.yhxt.statistics.vo.Org4BudgetVO;
import com.artfess.yhxt.statistics.vo.Org4bridgeInfoVO;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;

import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * 桥梁信息表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-07-27
 */
@RestController
@RequestMapping("/bizBridgeInformation/v1/")
@Api(tags = "桥梁管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BridgeInformationController extends BaseController<BridgeInformationManager, BridgeInformation> {
    @RequestMapping(value = "/saveBridge", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改桥梁信息", httpMethod = "POST")
    public CommonResult<String> saveBridge(@ApiParam(name = "bizBridgeInformation", value = "桥梁对象") @RequestBody BridgeInformation bizBridgeInformation) throws Exception {
        String msg = "添加成功";
        //检查桥梁编码是否重复
      //  this.baseService.checkNumber(bizBridgeInformation);
        if (StringUtils.isEmpty(bizBridgeInformation.getId())) {
            bizBridgeInformation.setIsDele("0");
            bizBridgeInformation.setSn(baseService.getSn());
            baseService.saveBridge(bizBridgeInformation);
        } else {
            baseService.updateBridge(bizBridgeInformation);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }

    @RequestMapping(value = "getBridgeVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取桥梁统计", httpMethod = "POST", notes = "获取桥梁统计")
    public List<Org4bridgeInfoVO> getBridgeVo() throws Exception {
        return baseService.getBridgeInfoCount();
    }

    @RequestMapping(value = "getBridgeCountVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取基础数量", httpMethod = "POST", notes = "获取基础数量")
    public List<Org4BridgeVO> getBridgeCountVo() throws Exception {
        return baseService.getBridgeCount();
    }

    @RequestMapping(value="/getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询桥梁信息",httpMethod = "POST")
   // @DataAccess
    public PageList<BridgeInformation> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BridgeInformation> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageList<BridgeInformation> pageList = baseService.queryBridgeInformation(queryFilter);
        return  pageList;
    }

    @RequestMapping(value="/getList",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "不分页查询桥梁信息",httpMethod = "POST")
    public PageList<BridgeInformation> getList(@ApiParam(name="queryFilter", value="不分页查询信息") @RequestBody QueryFilter<BridgeInformation> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE);
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        PageList<BridgeInformation>   bridge = baseService.query(queryFilter);
        return bridge;
    }



    @GetMapping(value="get/{id}")
    @ApiOperation(value="根据ID查询桥梁信息",httpMethod = "GET",notes = "根据ID查询桥梁信息")
    public BridgeInformation get(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
        return baseService.getBridgeById(id);
    }


    @RequestMapping(value = "/updateBridge", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除桥梁", httpMethod = "DELETE", notes = "逻辑删除桥梁")
    public CommonResult<String> updateBridge(@ApiParam(name = "ids", value = "可视化分类ID集合以，隔开", required = true)
                                                 @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BridgeInformation> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除删除桥梁信息", httpMethod = "DELETE", notes = "批量删除删除桥梁信息")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true, "删除成功");
    }


    @RequestMapping(value = "/updateBySn", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改排序号", httpMethod = "POST")
    public CommonResult<String> updateBySn(@ApiParam(name = "params", value = "排序参数：Key：ID，Value：排序号") @RequestBody HashMap<String, Integer> params) throws Exception {
        baseService.updateSequence(params);
        return new CommonResult<>(true, "排序完成");
    }

    @RequestMapping(value="/getJsonVo",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询桥梁经常检查信息",httpMethod = "POST")
    public PageList<BridgeCheckVo> getJsonVo(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BridgeInformation> queryFilter) throws Exception {

        PageList<BridgeCheckVo> pageList = baseService.queryBridge(queryFilter);
        return  pageList;
    }

    @RequestMapping(value="getJsonRegularVo",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询桥梁定期检查Vo",httpMethod = "POST")
    public PageList<BridgeRegularVo> getJsonRegularVo(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BridgeInformation> queryFilter) throws Exception {
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        PageList<BridgeRegularVo> pageList = baseService.queryBridgeRegularCheckVo(queryFilter);
        return  pageList;
    }
}
