package com.artfess.yhxt.thirdparty.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.thirdparty.model.BizTpBridge;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.thirdparty.vo.BridgeResourceVo;
import com.artfess.yhxt.thirdparty.vo.TpBridgeCountVo;
import com.artfess.yhxt.thirdparty.vo.TpBridgePageVo;

import java.util.List;

/**
 * 第三方传输桥梁基础信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-06-15
 */
public interface BizTpBridgeManager extends BaseManager<BizTpBridge> {
    BizTpBridge selectByCode(String bridgeCode);

    TpBridgeCountVo getBridgeCount(QueryFilter<BizTpBridge> queryFilter);



    PageList<TpBridgePageVo> pageVo(QueryFilter<BizTpBridge> queryFilter);

    BizTpBridge selectById(String id);

    BridgeResourceVo detailById(String id);

}
