package com.artfess.yhxt.task.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialcheck.model.SiteInspection;
import com.artfess.yhxt.specialcheck.vo.SiteTaskVo;
import com.artfess.yhxt.task.model.TaskWaitHandle;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.task.vo.TaskWaitHandleVo;

/**
 * 主要是从各个业务过程中向里面插入待处理的任务数据，然后提供门户进行统一查询跳转并处理 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2021-09-16
 */
public interface TaskWaitHandleManager extends BaseManager<TaskWaitHandle> {

    /**
     * 创建巡检
     * @param siteInspection 巡检对象
     * @param bizType 业务类型
     */
    void saveTask(SiteInspection siteInspection, String bizType);



    /**
     * 分页查询待办信息
     * @param queryFilter
     * @return
     */
    PageList<TaskWaitHandleVo> queryTaskWaitHandle(QueryFilter<TaskWaitHandle> queryFilter);

    /**
     * 修改巡检单
     * @param siteTaskVo
     */
    void updateTask(SiteTaskVo siteTaskVo);

    /**
     * 另派人员 接口
     * @param siteTaskVo
     */
    void otherSendPeople(SiteTaskVo siteTaskVo);
}
