package com.artfess.yhxt.statistics.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author zhx
 * @create 2022/3/8
 */
@Data
@ApiModel(value = "MaintainMessageVo 对象", description = "各类别养护金额")
public class MaintainMessageVo {

    @ApiModelProperty(value = "id")
    private String id;
    @ApiModelProperty(value = "公司Id")
    private String orgId;
    @ApiModelProperty(value = "公司Name")
    private String orgName;
    @ApiModelProperty(value = "管理中心Id")
    private String companyId;
    @ApiModelProperty(value = "管理中心")
    private String companyName;
    @ApiModelProperty(value = "开始桩号")
    private String startPegK;
    @ApiModelProperty(value = "结束桩号")
    private String endPegK;
    @ApiModelProperty(value = "通车时间")
    private String operationDay;
    @ApiModelProperty(value = "路段长度(km)")
    private BigDecimal roadLength = BigDecimal.ZERO;
    @ApiModelProperty(value = "路段ID")
    private String roadSegmentId;
    @ApiModelProperty(value = "路段名称")
    private String roadSegmentName;
    @ApiModelProperty(value = "路段宽度")
    private BigDecimal roadWidth = BigDecimal.ZERO;
    @ApiModelProperty(value = "桥梁数量")
    private Integer bridgeCount = 0;
    @ApiModelProperty(value = "桥梁单幅总长(m)")
    private BigDecimal bridgeSingleCount = BigDecimal.ZERO;
    @ApiModelProperty(value = "桥梁延米总长(m)")
    private BigDecimal bridgeLinearMeter = BigDecimal.ZERO;
    @ApiModelProperty(value = "特大桥数量")
    private Integer extraBigBridgeCount = 0;
    @ApiModelProperty(value = "特大桥桥梁单幅总长(m)")
    private BigDecimal extraBigBridgeSingleCount = BigDecimal.ZERO;
    @ApiModelProperty(value = "特大桥桥梁延米总长(m)")
    private BigDecimal extraBigBridgeLinearMeter = BigDecimal.ZERO;
    @ApiModelProperty(value = "大桥数量")
    private Integer bigBridgeCount = 0;
    @ApiModelProperty(value = "大桥桥梁单幅总长(m)")
    private BigDecimal bigBridgeSingleCount = BigDecimal.ZERO;
    @ApiModelProperty(value = "大桥桥梁延米总长(m)")
    private BigDecimal bigBridgeLinearMeter = BigDecimal.ZERO;
    @ApiModelProperty(value = "中桥数量")
    private Integer middleBridgeCount = 0;
    @ApiModelProperty(value = "中桥桥梁单幅总长(m)")
    private BigDecimal middleBridgeSingleCount = BigDecimal.ZERO;
    @ApiModelProperty(value = "中桥桥梁延米总长(m)")
    private BigDecimal middleBridgeLinearMeter = BigDecimal.ZERO;
    @ApiModelProperty(value = "小桥数量")
    private Integer smallBridgeCount = 0;
    @ApiModelProperty(value = "小桥桥梁单幅总长(m)")
    private BigDecimal smallBridgeSingleCount = BigDecimal.ZERO;
    @ApiModelProperty(value = "小桥桥梁延米总长(m)")
    private BigDecimal smallBridgeLinearMeter = BigDecimal.ZERO;
    @ApiModelProperty(value = "隧道数量")
    private Integer tunnelCount = 0;
    @ApiModelProperty(value = "隧道单洞总长(m)")
    private BigDecimal tunnelSingleCount = BigDecimal.ZERO;
    @ApiModelProperty(value = "隧道延米总长(m)")
    private BigDecimal tunnelLinearMeter = BigDecimal.ZERO;
    @ApiModelProperty(value = "特长隧道数量")
    private Integer extraBigTunnelCount = 0;
    @ApiModelProperty(value = "特长隧道单洞总长(m)")
    private BigDecimal extraBigTunnelSingleCount = BigDecimal.ZERO;
    @ApiModelProperty(value = "特长隧道延米总长(m)")
    private BigDecimal extraBigTunnelLinearMeter = BigDecimal.ZERO;
    @ApiModelProperty(value = "长隧道数量")
    private Integer bigTunnelCount = 0;
    @ApiModelProperty(value = "长隧道单洞总长(m)")
    private BigDecimal bigTunnelSingleCount = BigDecimal.ZERO;
    @ApiModelProperty(value = "长隧道延米总长(m)")
    private BigDecimal bigTunnelLinearMeter = BigDecimal.ZERO;
    @ApiModelProperty(value = "中隧道数量")
    private Integer middleTunnelCount = 0;
    @ApiModelProperty(value = "中隧道单洞总长(m)")
    private BigDecimal middleTunnelSingleCount = BigDecimal.ZERO;
    @ApiModelProperty(value = "中隧道延米总长(m)")
    private BigDecimal middleTunnelLinearMeter = BigDecimal.ZERO;
    @ApiModelProperty(value = "短隧道数量")
    private Integer smallTunnelCount = 0;
    @ApiModelProperty(value = "短隧道单洞总长(m)")
    private BigDecimal smallTunnelSingleCount = BigDecimal.ZERO;
    @ApiModelProperty(value = "短隧道延米总长(m)")
    private BigDecimal smallTunnelLinearMeter = BigDecimal.ZERO;
    @ApiModelProperty(value = "涵洞数量")
    private Integer culvertCount = 0;
    @ApiModelProperty(value = "边坡")
    private Integer sideSlopeCount = 0;


}
