package com.artfess.yhxt.statistics.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-07-04
 */
@Data
@ApiModel(value="CamerasResource对象", description="")
public class CamerasResource extends BaseModel<CamerasResource> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "监控点编号（通用唯一识别码UUID")
    @TableId(value = "CAMERA_INDEX_CODE_", type = IdType.ASSIGN_ID)
    private String cameraIndexCode;

    @ApiModelProperty(value = "名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "所属组织编号（通用唯一识别码UUID）")
    @TableField("UNIT_INDEX_CODE_")
    private String unitIndexCode;

    @ApiModelProperty(value = "监控点国标编号 ")
    @TableField("GB_INDEX_CODE_")
    private String gbIndexCode;

    @ApiModelProperty(value = "所属设备编号（通用唯一识别码UUID ")
    @TableField("DEVICE_INDEX_CODE_")
    private String deviceIndexCode;

    @ApiModelProperty(value = "经度")
    @TableField("LONGITUTE_")
    private String longitute;

    @ApiModelProperty(value = "纬度")
    @TableField("LATITUDE_")
    private String latitude;

    @TableField("TENANT_ID_")
    private String tenantId ="-1";


}
