package com.artfess.yhxt.statistics.dao;

import com.artfess.yhxt.contract.model.WorkOrderInformation;
import com.artfess.yhxt.contract.vo.WorkOrderCountVO;
import com.artfess.yhxt.disease.model.Disease;
import com.artfess.yhxt.statistics.model.SiteStatistic;
import com.artfess.yhxt.statistics.model.WorkStatistic;
import com.artfess.yhxt.statistics.model.YearBudgetSum;
import com.artfess.yhxt.statistics.vo.CheckVo;
import com.artfess.yhxt.statistics.vo.CountDisease;
import com.artfess.yhxt.statistics.vo.CountTypeDisease;
import com.artfess.yhxt.statistics.vo.MoneyVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * Mapper 接口
 *
 * @author xzh
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-10-26
 */
public interface WorkStatisticDao extends BaseMapper<WorkStatistic> {
    //工单根据公司
    List<WorkStatistic> getWorkJson(@Param("map") Map<String, Object> map);

    //巡检 根据公司进行分组查询
    List<SiteStatistic> getSiteJson(@Param("map") Map<String, Object> map);

    //经常定期 根据公司进行分组查询
    List<CheckVo> getCheckJson(@Param("map") Map<String, Object> map);

    //巡检下转根据桥梁进行分组查询
    List<SiteStatistic> getCompanySiteJson(@Param("map") Map<String, Object> map);

    //根据公司查询养护金额
    List<MoneyVo> getMoneyCompanyJson(@Param("map") Map<String, Object> map);

    List<YearBudgetSum> getYearBudgetJson(@Param("map") Map<String, Object> map);

    List<WorkStatistic> getCompanyWorkJson(@Param("map") Map<String, Object> map);

    //根据路段查询养护金额
    List<MoneyVo> getMoneyRoadSegmentIdJson(@Param("map") Map<String, Object> map);

/*    //查询已完成
    Integer countAmountDiseaseFinished(@Param("id") String id);
    //未完成
    Integer countAmountDiseaseUnFinished(@Param("id") String id);*/

    //查询已完成
    Integer countAmountDiseaseFinished(@Param("map") Map<String, Object> map);
    //未完成
    Integer countAmountDiseaseUnFinished(@Param("map") Map<String, Object> map);
    //病害类型
    List<Disease> countTypeDisease(@Param("map") Map<String, Object> map);
    //根据路段ID查询该路段处理完成的病害的总天数
    Integer countDayDiseaseSum(@Param("map") Map<String, Object> map);

    Integer countDiseaseSum(@Param("map") Map<String, Object> map);

    List<Map<String,Object>> countWorkOrder(@Param("map") Map<String, Object> map);

    List<WorkOrderInformation> selectWordOrder(@Param("map") Map<String, Object> map);

    WorkStatistic countWorkStatistic(@Param("map") Map map, @Param("id")String id);

    SiteStatistic countSiteStatistic(@Param("map") Map map, @Param("id") String id);

    List<CheckVo> countcheckVo(@Param("map") Map map,  @Param("id")String id);

    MoneyVo countMoneyRoadSegment(@Param("map") Map map, @Param("id") String id);

    List<YearBudgetSum> countYearBudgetData(@Param("map") Map<String, Object> map);

    List<Map<String,Object>> countWorkOrder4Open(@Param("map") Map<String, Object> map);


    List<WorkOrderCountVO> countWorkOrder4New(@Param("map") Map<String, Object> map);

    BigDecimal countWorkOrderFinishMoney(@Param("map") Map<String, Object> map);
}
