package com.artfess.yhxt.statistics.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.statistics.model.SiteStatistic;
import com.artfess.yhxt.statistics.vo.*;
import com.artfess.yhxt.statistics.model.YearBudgetSum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.statistics.model.WorkStatistic;
import com.artfess.yhxt.statistics.manager.WorkStatisticManager;

import java.util.List;

/**
 *  前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-10-26
 */
@RestController
@RequestMapping("/bizWorkStatistic/v1/")
@Api(tags = "业务数据统计接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class WorkStatisticController extends BaseController<WorkStatisticManager, WorkStatistic> {
    @RequestMapping(value = "/getWorkJson", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "查询养护工单信息", httpMethod = "POST")
    public List<WorkStatistic> getWorkJson(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter<WorkStatistic> queryFilter) throws Exception {
        return this.baseService.getWorkJson(queryFilter);
    }

    @RequestMapping(value = "/getSiteJson", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "查询日/夜巡检信息", httpMethod = "POST")
    public List<SiteStatistic> getSiteJson(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter<WorkStatistic> queryFilter) throws Exception{
        return this.baseService.getSiteJson(queryFilter);
    }

    @RequestMapping(value = "/getCheckJson", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "查询经常/定期检查信息", httpMethod = "POST")
    public List<CheckVo> getCheckJson(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter<WorkStatistic> queryFilter) throws Exception{
        return this.baseService.getCheckJson(queryFilter);
    }

    @RequestMapping(value = "/countCheckRodeJson", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "查询经常/定期检查信息-路段", httpMethod = "POST")
    public  List<CheckRoadVo>  countCheckRodeJson(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter<WorkStatistic> queryFilter) throws Exception{
        return this.baseService.getCheckRodeJson(queryFilter);
    }

    @RequestMapping(value = "/getMoneyJson", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "查询养护金额总数", httpMethod = "POST")
    public List<MoneyVo> getMoneyJson(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter<WorkStatistic> queryFilter)throws Exception {
        return this.baseService.getMoneyJson(queryFilter);
    }

    @RequestMapping(value = "/getYearBudgetJson", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "查询预算金额", httpMethod = "POST")
    public List<YearBudgetSum> getYearBudgetJson(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter<WorkStatistic> queryFilter)throws Exception {
        return this.baseService.getYearBudgetJson(queryFilter);
    }

    @RequestMapping(value = "/countAmountDisease", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "病害数量统计", httpMethod = "POST")
    public List<CountDisease> countAmountDisease(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter queryFilter)throws Exception {

        return this.baseService.countAmountDisease(queryFilter);
    }

    @RequestMapping(value = "/countTypeDisease", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "病害类型统计", httpMethod = "POST")
    public  List<CountTypeDisease> countTypeDisease(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter<WorkStatistic> queryFilter)throws Exception {

        return this.baseService.countTypeDisease( queryFilter);
    }

    @RequestMapping(value = "/countDayDisease", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "病害平均处理天数", httpMethod = "POST")
    public List<CountDayDisease> countDayDisease(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter<WorkStatistic> queryFilter)throws Exception {
        return  this.baseService.countDayDisease(queryFilter);
    }

    @RequestMapping(value = "/countWorkOrder", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "养护工单执行状况", httpMethod = "POST")
    public CountWorkOrder countWorkOrder(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter<WorkStatistic> queryFilter)throws Exception {
          return this.baseService.countWorkOrder(queryFilter);
    }

    @RequestMapping(value = "/newCountWorkOrder", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "新养护工单执行状况", httpMethod = "POST")
    public  List<NewCountWorkOrderVo> newCountWorkOrder(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter<WorkStatistic> queryFilter)throws Exception {
        return this.baseService.newCountWorkOrder(queryFilter);
    }


    @RequestMapping(value = "/countSpecialProject", method = RequestMethod.POST, produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "专项工程", httpMethod = "POST")
    public List<CountSpecialProject> countSpecialProject(@ApiParam(name = "queryFilter", value = "查询信息") @RequestBody QueryFilter<WorkStatistic> queryFilter)throws Exception {
        return this.baseService.countSpecialProject(queryFilter);
    }

}
