package com.artfess.yhxt.statistics.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.yhxt.basedata.dao.RoadDao;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.BizCourseDetails;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.statistics.manager.StatisticalStatementManager;
import com.artfess.yhxt.statistics.model.WorkStatistic;
import com.artfess.yhxt.statistics.vo.*;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zhx
 * @create 2022/1/6
 */
@RestController
@RequestMapping("/statisticalStatement/v1/")
@Api(tags = "统计报表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class StatisticalStatementController {
    @Resource
    StatisticalStatementManager statisticalStatementManager;
    @Resource
    RoadManager roadManager;


    @RequestMapping(value = "findAllRoadIds", method = RequestMethod.GET)
    @ApiOperation(value = "查询所属路段", httpMethod = "GET")
    public CommonResult<List<String>> findAllRoadIds(String id) {
        QueryWrapper<Road> queryWrapper = new QueryWrapper<>();
        queryWrapper.like("COMPANY_IDS_",id);
        queryWrapper.eq("IS_DELE_","0");
        List<String> list = roadManager.list(queryWrapper).stream().map(Road :: getId).collect(Collectors.toList());
        return new CommonResult<>(true,"成功",list);
    }


    @RequestMapping(value = "countDisease", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "道路病害统计", httpMethod = "POST")
    public Map<String, Object> countDisease(@ApiParam(name = "map", value = "roadSegmentId:路段id,companyId:公司id startTime:开始时间 endTime:结束时间")
                                                @RequestBody Map<String, Object> map) {
        return statisticalStatementManager.countDisease(map);
    }

    @RequestMapping(value = "countMaintenance", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "日常养护统计-废弃", httpMethod = "POST")
    public Map<String, Object> countMaintenance(@ApiParam(name = "map", value = "roadSegmentId:路段id,companyId:公司id , pcode: 类别Code,subjectCode:细目Code")
                                                    @RequestBody Map<String, Object> map) {
        return statisticalStatementManager.countMaintenance(map);
    }

    @RequestMapping(value = "countMaintenance/new", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "日常养护统计", httpMethod = "POST")
    public Map<String, Object> countMaintenanceNew(@ApiParam(name = "map", value = "roadSegmentId:路段id（每次必传一条路段id）,companyId:公司id , pcode: 类别Code")
                                                @RequestBody Map<String, Object> map) {
        return statisticalStatementManager.countMaintenanceNew(map);
    }

    @RequestMapping(value = "countSiteDaily", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "日巡检", httpMethod = "POST")
    public Map<String, Object> countSiteDaily(@ApiParam(name = "map", value = "roadSegmentId:路段id, startTime:开始时间 endTime:结束时间")
                                                @RequestBody Map<String, Object> map) {
        return statisticalStatementManager.countSiteDaily(map);
    }

    @RequestMapping(value = "countSiteNight", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "夜巡检", httpMethod = "POST")
    public Map<String, Object> countSiteNight(@ApiParam(name = "map", value = "roadSegmentId:路段id, startTime:开始时间 endTime:结束时间")
                                                @RequestBody Map<String, Object> map) {
        return statisticalStatementManager.countSiteNight(map);
    }

    @RequestMapping(value = "countBridgeCheck", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "桥梁经常检查", httpMethod = "POST")
    public Map<String, Object> countBridgeCheck(@ApiParam(name = "map", value = "roadSegmentId:路段id, accDateYear:年 accDateMonth:月  默认传当前年当前月")
                                              @RequestBody Map<String, Object> map) {
        return statisticalStatementManager.countBridgeCheck(map);
    }

    @RequestMapping(value = "countTunnelCheck", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "隧道经常检查", httpMethod = "POST")
    public Map<String, Object> countTunnelCheck(@ApiParam(name = "map", value = "roadSegmentId:路段id, accDateYear:年 accDateMonth:月  默认传当前年当前月")
                                              @RequestBody Map<String, Object> map) {
        return statisticalStatementManager.countTunnelCheck(map);
    }

    @RequestMapping(value = "countSideSlopCheck", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "边坡经常检查", httpMethod = "POST")
    public Map<String, Object> countSideSlopCheck(@ApiParam(name = "map", value = "roadSegmentId:路段id, accDateYear:年 accDateMonth:月  默认传当前年当前月")
                                              @RequestBody Map<String, Object> map) {
        return statisticalStatementManager.countSideSlopCheck(map);
    }
    @RequestMapping(value = "countCulvertCheck", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "涵洞经常检查", httpMethod = "POST")
    public Map<String, Object> countCulvertCheck(@ApiParam(name = "map", value = "roadSegmentId:路段id, accDateYear:年 startTime:开始月  endTime：结束月")
                                                  @RequestBody Map<String, Object> map) {
        return statisticalStatementManager.countCulvertCheck(map);
    }

    @RequestMapping(value = "countReportBridge", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "桥梁结构统计", httpMethod = "POST")
    public Map<String, Object> countReportBridge(@ApiParam(name = "map", value = "roadSegmentId:路段id")
                                              @RequestBody Map<String, Object> map) {
        return statisticalStatementManager.countReportBridge(map);
    }

    @RequestMapping(value = "exportBridge", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "桥梁结构-导出", httpMethod = "POST")
    public void exportBridge(HttpServletResponse response, @ApiParam(name = "map", value = "roadSegmentId:路段id")
                                              @RequestBody Map<String, Object> map) {
        try {
            HSSFWorkbook workbook = statisticalStatementManager.exportBridge(response, map);
            ExcelUtil.downloadExcel(workbook,"桥梁结构",response);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }



    @RequestMapping(value = "countMqiReport", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "MQI统计", httpMethod = "POST")
    public CommonResult<List<MqiDataVo>>  mqiReport(@ApiParam(name = "map", value = "roadSegmentId:路段id year:年份") @RequestBody Map<String, Object> map) {
        List<MqiDataVo> vos = statisticalStatementManager.countMqiReport(map);
        return new CommonResult<List<MqiDataVo>>(true,"操作成功",vos);
    }
    @RequestMapping(value = "countStructure", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "结构物检查情况", httpMethod = "POST")
    public CommonResult<List<CountStructureVo>>  countStructure(@ApiParam(name = "map", value = "roadSegmentId:路段id") @RequestBody Map<String, Object> map) {
        return new CommonResult<List<CountStructureVo>>(true,"操作成功",statisticalStatementManager.countStructure(map));
    }


    @RequestMapping(value = "maintainMessage", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "管养信息统计", httpMethod = "POST")
    public CommonResult<List<MaintainMessageVo>>  maintainMessage(@ApiParam(name = "map", value = "roadSegmentId:路段id") @RequestBody Map<String, Object> map) {
        List<MaintainMessageVo> maintainMessageVos = statisticalStatementManager.maintainMessage(map);
        return new CommonResult<List<MaintainMessageVo>>(true,"操作成功",maintainMessageVos);
    }


    @RequestMapping(value = "getMessageCountVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取管养信息统计数量", httpMethod = "POST", notes = "获取管养信息统计数量")
    public List<OrgMessageVo> getMessageCountVo() throws Exception {
        return statisticalStatementManager.getMessageCountVo();
    }
}
