package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 项目合同支付表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-19
 */
@ApiModel(value="ProjectContractPayment对象", description="项目合同支付表")
@TableName("biz_project_contract_payment")
public class ProjectContractPayment extends BizModel<ProjectContractPayment> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "对应合同ID")
    @TableField("CONTRACT_ID_")
    private String contractId;

    @ApiModelProperty(value = "项目编码，成本科目字典，保存编码")
    @TableField("PROJECT_CODE_")
    private String projectCode;

    @ApiModelProperty(value = "项目细目编码，成本科目子项目名称，保存对应编码")
    @TableField("SUBJECT_CODE_")
    private String subjectCode;

    @ApiModelProperty(value = "单位")
    @TableField("UNIT_")
    private String unit;

    @ApiModelProperty(value = "数量")
    @TableField("AMOUNT_")
    private Double amount;

    @ApiModelProperty(value = "单价")
    @TableField("PRICE_")
    private Double price;

    @ApiModelProperty(value = "总价")
    @TableField("TOTAL_PRICE_")
    private Double totalPrice;

    @ApiModelProperty(value = "支付日期")
    @TableField("PAY_DATE_")
    private LocalDate payDate;


    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public Double getAmount() {
        return amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }
    public Double getPrice() {
        return price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }
    public Double getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(Double totalPrice) {
        this.totalPrice = totalPrice;
    }
    public LocalDate getPayDate() {
        return payDate;
    }

    public void setPayDate(LocalDate payDate) {
        this.payDate = payDate;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "ProjectContractPayment{" +
            "id=" + id +
            ", contractId=" + contractId +
            ", projectCode=" + projectCode +
            ", subjectCode=" + subjectCode +
            ", unit=" + unit +
            ", amount=" + amount +
            ", price=" + price +
            ", totalPrice=" + totalPrice +
            ", payDate=" + payDate +

        "}";
    }
}
